/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.lib.commons.table;

import java.util.List;
import javax.annotation.Nullable;
import org.opensingular.lib.commons.table.Column;
import org.opensingular.lib.commons.table.Decorator;
import org.opensingular.lib.commons.table.LineInfo;
import org.opensingular.lib.commons.table.LineReadContext;
import org.opensingular.lib.commons.table.TableOutput;
import org.opensingular.lib.commons.table.TableTool;

public final class OutputTableContext {
    private final TableTool tableTool;
    private final TableOutput tableOutput;
    private int indexCurrentColumn;
    private int indexCurrentLine;
    private LineInfo line;
    private List<Column> visibleColumns;
    private LineReadContext lineReadContext;

    OutputTableContext(TableTool tableTool, TableOutput tableOutput) {
        this.tableTool = tableTool;
        this.tableOutput = tableOutput;
    }

    public TableTool getTableTool() {
        return this.tableTool;
    }

    public TableOutput getOutput() {
        return this.tableOutput;
    }

    public void clean(int numLevel) {
        this.line = null;
        this.setLevel(numLevel);
    }

    @Nullable
    final LineInfo getLineIfExists() {
        return this.line;
    }

    private LineInfo getLine() {
        if (this.line == null) {
            this.line = this.tableTool.newBlankLine();
        }
        return this.line;
    }

    final void setLine(LineInfo lineInfo) {
        this.line = lineInfo;
    }

    public String getUrlApp() {
        return this.tableOutput.getUrlApp();
    }

    public Decorator getDecorator() {
        return this.getLine().getDecorator();
    }

    final int getVisibleColumnsSize() {
        return this.visibleColumns.size();
    }

    final void setIndexCurrentColumn(int i) {
        this.indexCurrentColumn = i;
    }

    final int getIndexCurrentColumn() {
        return this.indexCurrentColumn;
    }

    public final int getIndexCurrentLine() {
        return this.indexCurrentLine;
    }

    final void incIndexCurrentLine() {
        ++this.indexCurrentLine;
    }

    public final void setLevel(int level) {
        this.getLine().setLevel(level);
    }

    public int getLevel() {
        return this.getLine().getLevel();
    }

    final boolean isShowLine() {
        return this.line == null ? true : this.getLine().isShowLine();
    }

    public void setShowLine(boolean showLine) {
        if (this.line != null || !showLine) {
            this.getLine().setShowLine(showLine);
        }
    }

    public boolean isStaticContent() {
        return this.tableOutput.isStaticContent();
    }

    public List<Column> getVisibleColumns() {
        return this.visibleColumns;
    }

    final void setVisibleColumns(List<Column> visibleColumns) {
        this.visibleColumns = visibleColumns;
    }

    public LineReadContext getLineReadContext() {
        if (this.lineReadContext == null) {
            this.lineReadContext = new LineReadContext(this.tableTool);
        }
        return this.lineReadContext;
    }
}

