/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.lib.commons.table;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.opensingular.lib.commons.table.Column;
import org.opensingular.lib.commons.table.Decorator;
import org.opensingular.lib.commons.table.DecoratorCell;
import org.opensingular.lib.commons.table.LineInfo;
import org.opensingular.lib.commons.table.OutputCellContext;
import org.opensingular.lib.commons.table.OutputTableContext;
import org.opensingular.lib.commons.table.TableOutput;
import org.opensingular.lib.commons.table.TableTool;
import org.opensingular.lib.commons.util.Loggable;
import org.opensingular.lib.commons.views.format.ViewOutputExcel;

public class TableOutputExcel
extends TableOutput
implements Loggable {
    private final ViewOutputExcel viewOutputExcel;
    private int rowIndex = -1;
    private int columnIndex = -1;
    private XSSFRow row;
    private Map<Integer, Integer> columnRowSpanMap = new HashMap<Integer, Integer>();

    public TableOutputExcel(ViewOutputExcel viewOutputExcel) {
        this.viewOutputExcel = viewOutputExcel;
    }

    private void incrementRow() {
        ++this.rowIndex;
    }

    private void incrementColumn() {
        ++this.columnIndex;
    }

    private void newRow() {
        this.incrementRow();
        this.row = this.viewOutputExcel.getOutput().createRow(this.rowIndex);
        this.columnIndex = -1;
    }

    @Override
    public String getUrlApp() {
        return "";
    }

    @Override
    public boolean isStaticContent() {
        return false;
    }

    @Override
    public void generateTableStart(@Nonnull OutputTableContext ctx, @Nonnull TableTool tableTool) {
    }

    @Override
    public void generateTableEnd(@Nonnull OutputTableContext ctx, @Nonnull TableTool tableTool) {
    }

    @Override
    public void generateBodyBlockStart(@Nonnull OutputTableContext ctx) {
    }

    @Override
    public void generateBodyBlockEnd(@Nonnull OutputTableContext ctx) {
    }

    @Override
    public void generateLineSimpleStart(@Nonnull OutputTableContext ctx, @Nonnull LineInfo line, int lineAlternation) {
        if (line.isShowLine()) {
            this.newRow();
        }
    }

    @Override
    public void generateLineSimpleEnd(@Nonnull OutputTableContext ctx) {
    }

    @Override
    public void generateLineTreeStart(@Nonnull OutputTableContext ctx, @Nonnull LineInfo line, int level) {
    }

    @Override
    public void generateLineTreeEnd(@Nonnull OutputTableContext ctx) {
    }

    @Override
    public void generateCell(@Nonnull OutputCellContext ctx) {
        XSSFCell cell = this.incrementColumnAndCreateNewCell();
        this.configAlignment(cell.getCellStyle(), ctx.getColumn().getAlignment());
        if (ctx.getValue() == null) {
            return;
        }
        switch (ctx.getCell().getColumn().getType()) {
            case INTEGER: 
            case NUMBER: 
            case MONEY: {
                cell.setCellValue(((Number)ctx.getValue()).doubleValue());
                break;
            }
            case STRING: {
                cell.setCellValue((String)ctx.getValue());
                break;
            }
            default: {
                cell.setCellValue(ctx.generateFormatDisplayString());
            }
        }
        this.viewOutputExcel.getOutput().autoSizeColumn(cell.getColumnIndex());
    }

    private void configAlignment(XSSFCellStyle cellStyle, Column.Alignment alignment) {
        switch (alignment) {
            case CENTER: {
                cellStyle.setAlignment(HorizontalAlignment.CENTER);
                break;
            }
            case RIGHT: {
                cellStyle.setAlignment(HorizontalAlignment.RIGHT);
                break;
            }
            case LEFT: {
                cellStyle.setAlignment(HorizontalAlignment.LEFT);
            }
        }
    }

    @Override
    public void generateTitleBlockStart(@Nonnull OutputTableContext ctx) {
    }

    @Override
    public void generateTitleBlockEnd(@Nonnull OutputTableContext ctx) {
    }

    @Override
    public void generateTitleLineStart(@Nonnull OutputTableContext ctx, boolean superTitleLine) {
        this.newRow();
    }

    @Override
    public void generateTitleLineEnd(@Nonnull OutputTableContext ctx, boolean superTitleLine) {
    }

    @Override
    public void generateTitleCell(@Nonnull OutputTableContext ctx, @Nonnull Column column, int rowSpan, boolean asSubTitle, boolean columnWithSeparator) {
        if (column.getTitle() == null) {
            return;
        }
        this.incrementColumn();
        while (this.containsRowSpanForColumn()) {
            this.incrementColumn();
            if (!this.containsRowSpanForColumn()) continue;
            this.columnRowSpanMap.put(this.columnIndex, this.columnRowSpanMap.get(this.columnIndex) - 1);
        }
        XSSFCell cell = this.row.createCell(this.columnIndex);
        cell.setCellValue(column.getTitle());
        if (rowSpan > 1) {
            int spanOffset = rowSpan - 1;
            this.columnRowSpanMap.put(this.columnIndex, spanOffset);
            this.viewOutputExcel.getOutput().addMergedRegion(new CellRangeAddress(this.rowIndex, this.rowIndex + spanOffset, this.columnIndex, this.columnIndex));
        }
        this.viewOutputExcel.getOutput().autoSizeColumn(cell.getColumnIndex());
    }

    private boolean containsRowSpanForColumn() {
        return this.columnRowSpanMap.get(this.columnIndex) != null && this.columnRowSpanMap.get(this.columnIndex) > 0;
    }

    @Override
    public void generateTitleCellSuper(@Nonnull OutputTableContext ctx, @Nonnull Column column, int colSpan, boolean columnWithSeparator) {
        if (column.getTitle() != null) {
            XSSFCell cell = this.incrementColumnAndCreateNewCell();
            cell.setCellValue(column.getSuperTitle());
            if (colSpan > 1) {
                int spanOffset = colSpan - 1;
                this.viewOutputExcel.getOutput().addMergedRegion(new CellRangeAddress(this.rowIndex, this.rowIndex, this.columnIndex, this.columnIndex += spanOffset));
            }
        }
    }

    private XSSFCell incrementColumnAndCreateNewCell() {
        this.incrementColumn();
        return this.row.createCell(this.columnIndex);
    }

    @Override
    public void generateTotalBlockStart(@Nonnull OutputTableContext ctx) {
    }

    @Override
    public void generateTotalBlockEnd(@Nonnull OutputTableContext ctx) {
    }

    @Override
    public void generateTotalLineStart(@Nonnull OutputTableContext ctx, @Nonnull LineInfo totalLine, @Nonnull Decorator tempDecorator, int level) {
        if (totalLine.isShowLine()) {
            this.newRow();
        }
    }

    @Override
    public void generateTotalLineEnd(@Nonnull OutputTableContext ctx) {
    }

    @Override
    public void generateTotalCellSkip(@Nonnull OutputTableContext ctx, @Nonnull Column column, boolean columnWithSeparator) {
        this.incrementColumn();
    }

    @Override
    public void generateTotalLabel(@Nonnull OutputTableContext ctx, @Nonnull Column column, @Nonnull String label, @Nonnull DecoratorCell tempDecorator, int level) {
        XSSFCell cell = this.incrementColumnAndCreateNewCell();
        cell.setCellValue("Total");
    }

    @Override
    public void generateTotalCell(@Nonnull OutputCellContext ctx, @Nullable Number value) {
        XSSFCell cell = this.incrementColumnAndCreateNewCell();
        if (value != null) {
            cell.setCellValue(value.doubleValue());
        }
    }
}

