/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.lib.commons.table;

import com.google.common.base.Predicates;
import java.io.PrintWriter;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensingular.lib.commons.net.WebRef;
import org.opensingular.lib.commons.table.AlocproToolkit;
import org.opensingular.lib.commons.table.Column;
import org.opensingular.lib.commons.table.ColumnTypeProcessor;
import org.opensingular.lib.commons.table.Decorator;
import org.opensingular.lib.commons.table.DecoratorCell;
import org.opensingular.lib.commons.table.InfoCell;
import org.opensingular.lib.commons.table.LineInfo;
import org.opensingular.lib.commons.table.OutputCellContext;
import org.opensingular.lib.commons.table.OutputTableContext;
import org.opensingular.lib.commons.table.TableOutput;
import org.opensingular.lib.commons.table.TableTool;
import org.opensingular.lib.commons.views.format.ViewOutputHtml;

public class TableOutputHtml
extends TableOutput {
    private final ViewOutputHtml vOut;
    private final String tableid = UUID.randomUUID().toString();

    public TableOutputHtml(ViewOutputHtml vOut) {
        this.vOut = vOut;
    }

    @Override
    public String getUrlApp() {
        return this.vOut.getUrlApp();
    }

    @Override
    public boolean isStaticContent() {
        return this.vOut.isStaticContent();
    }

    public ViewOutputHtml getVOut() {
        return this.vOut;
    }

    final PrintWriter getOut() {
        return this.vOut.getPrintWriter();
    }

    final TableOutputHtml print(char c) {
        this.getOut().print(c);
        return this;
    }

    final TableOutputHtml print(Object o) {
        this.getOut().print(o);
        return this;
    }

    final TableOutputHtml print(String s) {
        this.getOut().print(s);
        return this;
    }

    final TableOutputHtml println(String s) {
        this.getOut().println(s);
        return this;
    }

    final TableOutputHtml println() {
        this.getOut().println();
        return this;
    }

    final TableOutputHtml printAttribute(String attributeName, int value) {
        return this.printAttribute(attributeName, Integer.toString(value));
    }

    final TableOutputHtml printAttribute(String attributeName, String value) {
        if (value != null) {
            PrintWriter out = this.getOut();
            out.print(' ');
            out.print(attributeName);
            out.print("=\"");
            out.print(value);
            out.print('\"');
        }
        return this;
    }

    @Override
    public void generateTableStart(OutputTableContext ctx, TableTool tableTool) {
        this.println();
        this.print("<table id='" + this.tableid + "' cellpadding='0' cellspacing='0'");
        if (tableTool.isStrippedLines()) {
            this.printAttribute("class", "T_t table table-bordered table-condensed table-hover table-striped");
        } else {
            this.printAttribute("class", "T_t table table-bordered table-condensed table-hover");
        }
        this.printAttribute("width", tableTool.getWidth());
        this.printAttribute("align", tableTool.getAlign());
        this.printAttribute("id", tableTool.getId());
        this.decorate(tableTool.getDecorator());
        this.println(">");
    }

    @Override
    public void generateTableEnd(OutputTableContext ctx, TableTool tableTool) {
        this.println("</table>");
        this.println();
        this.println("<script type='text/javascript'>");
        this.println("(function(){\nif(typeof $ !== 'undefined'){\n    $(document).ready(function(){\n        var table = $('#" + this.tableid + "');\n        if(table.DataTable){\n            table.DataTable(" + this.datatablesOptions() + ");\n        }\n    });}\n}());");
        this.println("</script>");
        this.println();
    }

    @Override
    public void generateBodyBlockStart(@Nonnull OutputTableContext ctx) {
        if (ctx.getTableTool().isSimpleTable()) {
            if (ctx.getTableTool().isStrippedLines()) {
                this.println("<tbody class=\"T_content_simple T_striped\">");
            } else {
                this.println("<tbody class=\"T_content_simple\">");
            }
        } else {
            this.println("<tbody class=\"T_content_tree\">");
        }
    }

    @Override
    public void generateBodyBlockEnd(@Nonnull OutputTableContext ctx) {
        this.println("</tbody>");
    }

    @Override
    public void generateLineSimpleStart(OutputTableContext ctx, LineInfo line, int lineAlternation) {
        if (lineAlternation != -1) {
            line.getDecorator().setCssClass(lineAlternation == 0 ? "T_ls0" : "T_ls1");
        }
        this.print("  <tr");
        this.decorate(line.getDecorator());
        this.println(">");
    }

    @Override
    public void generateLineSimpleEnd(OutputTableContext ctx) {
        this.println("  </tr>");
    }

    @Override
    public void generateLineTreeStart(OutputTableContext ctx, LineInfo line, int level) {
        if (ctx.getDecorator().getCssClass() == null) {
            ctx.getDecorator().setCssClass(level <= 4 ? "T_R_" + level : "T_R_N");
        }
        this.print("  <tr");
        this.decorate(line.getDecorator());
        this.println(">");
    }

    @Override
    public void generateLineTreeEnd(OutputTableContext ctx) {
        this.println("  </tr>");
    }

    @Override
    public void generateTitleBlockStart(OutputTableContext ctx) {
        this.getOut().println("<thead class=\"T_thead\">");
    }

    @Override
    public void generateTitleBlockEnd(OutputTableContext ctx) {
        this.getOut().println("</thead>");
    }

    @Override
    public void generateTitleLineStart(OutputTableContext ctx, boolean superTitleLine) {
        this.getOut().println("  <tr>");
    }

    @Override
    public void generateTitleLineEnd(OutputTableContext ctx, boolean superTitleLine) {
        this.getOut().println("  </tr>");
    }

    @Override
    public void generateTitleCell(OutputTableContext ctx, Column column, int rowSpan, boolean asSubTitle, boolean columnWithSeparator) {
        PrintWriter out = this.getOut();
        out.print("   <th");
        if (column.getWidth() != null) {
            this.printAttribute("width", column.getWidth());
        }
        if (rowSpan > 1) {
            this.printAttribute("rowspan", Integer.toString(rowSpan));
        }
        this.generateTitleCellClassAttribute(column, asSubTitle, columnWithSeparator, out);
        this.decorate(column.getDecoratorTitle());
        out.print(">");
        if (column.getTitle() == null) {
            out.print("&nbsp;");
        } else {
            if (column.isSmall()) {
                out.print("<small>");
            }
            if (column.isStrong()) {
                out.print("<strong>");
            }
            out.print(column.getTitle());
            if (column.isStrong()) {
                out.print("</strong>");
            }
            if (column.isSmall()) {
                out.print("</small>");
            }
        }
        out.println("</th>");
    }

    private void generateTitleCellClassAttribute(Column column, boolean asSubTitle, boolean columnWithSeparator, PrintWriter out) {
        if (asSubTitle) {
            switch (column.getAlignment()) {
                case CENTER: {
                    this.printClass(out, "T_subtit_cen", columnWithSeparator);
                    break;
                }
                case RIGHT: {
                    this.printClass(out, "T_subtit_dir", columnWithSeparator);
                    break;
                }
                default: {
                    this.printClass(out, "T_subtit", columnWithSeparator);
                    break;
                }
            }
        } else {
            switch (column.getAlignment()) {
                case CENTER: {
                    this.printClass(out, "T_tit_cen", columnWithSeparator);
                    break;
                }
                case RIGHT: {
                    this.printClass(out, "T_tit_dir", columnWithSeparator);
                    break;
                }
                default: {
                    this.printClass(out, null, columnWithSeparator);
                }
            }
        }
    }

    private void printClass(PrintWriter out, String style, boolean columnWithSeparator) {
        if (style != null || columnWithSeparator) {
            out.print(" class=\"");
            if (style != null) {
                out.print(style);
                if (columnWithSeparator) {
                    out.print(' ');
                    out.print("T_sep");
                }
            } else {
                out.print("T_sep");
            }
            out.print('\"');
        }
    }

    @Override
    public void generateTitleCellSuper(OutputTableContext ctx, Column column, int colSpan, boolean cColumnWithSeparator) {
        PrintWriter out = this.getOut();
        out.print("   <th");
        if (colSpan > 1) {
            this.printAttribute("colspan", colSpan);
        }
        this.printClass(out, "T_tit_super", cColumnWithSeparator);
        out.print(">");
        out.print(column.getSuperTitle());
        out.println("</th>");
    }

    @Override
    public void generateTotalBlockStart(@Nonnull OutputTableContext ctx) {
        this.println("<tfoot class=\"T_tfoot\">");
    }

    @Override
    public void generateTotalBlockEnd(@Nonnull OutputTableContext ctx) {
        this.println("</tfoot>");
    }

    @Override
    public void generateTotalLineStart(@Nonnull OutputTableContext ctx, @Nonnull LineInfo totalLine, @Nonnull Decorator tempDecorator, int level) {
        if (level != -1) {
            if (level <= 2) {
                tempDecorator.setCssClass("RA_TR_" + level);
            } else {
                tempDecorator.setCssClass("RA_TR_N");
            }
        } else {
            tempDecorator.setCssClass("T_l_tot");
        }
        PrintWriter out = this.getOut();
        out.print("  <tr");
        this.decorate(tempDecorator);
        out.println('>');
    }

    @Override
    public void generateTotalLineEnd(@Nonnull OutputTableContext ctx) {
        this.getOut().println("  </tr>");
    }

    @Override
    public void generateTotalCellSkip(@Nonnull OutputTableContext ctx, @Nonnull Column column, boolean columnWithSeparator) {
        if (columnWithSeparator) {
            this.getOut().println("   <td class=\"T_sep\">&nbsp;</td>");
        } else {
            this.getOut().println("   <td>&nbsp;</td>");
        }
    }

    @Override
    public void generateTotalLabel(@Nonnull OutputTableContext ctx, @Nonnull Column column, @Nonnull String label, @Nonnull DecoratorCell tempDecorator, int level) {
        tempDecorator.setCssClass("T_tot_label");
        PrintWriter out = this.getOut();
        out.print("   <td");
        this.decorate(tempDecorator);
        out.print('>');
        out.print(label);
        out.println("</td>");
    }

    @Override
    public void generateTotalCell(@Nonnull OutputCellContext ctx, @Nullable Number value) {
        String s;
        ctx.getTempDecorator().setCssClass(this.resolveCellCss(ctx.getColumn(), -1, ctx.isColumnWithSeparator()));
        PrintWriter out = this.getOut();
        out.print("   <td");
        this.decorate(ctx.getTempDecorator());
        out.print(">");
        if (value != null && !ctx.isActionCell() && (s = ctx.generateFormatDisplayString(value)) != null) {
            out.print(s);
        }
        out.println("</td>");
    }

    @Override
    public void generateCell(@Nonnull OutputCellContext ctx) {
        InfoCell cell = ctx.getCell();
        Column column = ctx.getColumn();
        DecoratorCell tempDecorator = ctx.getTempDecorator();
        PrintWriter out = this.getOut();
        if (ctx.getLevel() != -1) {
            tempDecorator.addStyle("padding-left", ctx.getLevel() * 16 + "px");
        }
        if (tempDecorator.getCssClass() == null) {
            tempDecorator.setCssClass(this.resolveCellCss(column, ctx.getLevel(), ctx.isColumnWithSeparator()));
        } else if (ctx.isColumnWithSeparator()) {
            tempDecorator.setCssClass(tempDecorator.getCssClass() + " T_sep");
        }
        if (ctx.isActionCell()) {
            tempDecorator.setNoWrap();
        }
        out.print("   <td");
        this.decorateCell(tempDecorator);
        out.print(">");
        if (ctx.isNullContent()) {
            out.print("&nbsp;");
            out.println("</td>");
            return;
        }
        this.cellTagsOpen(ctx, cell, column, out);
        if (ctx.isActionCell()) {
            out.print(TableOutputHtml.generateActions(this.getVOut(), ctx.getCell()));
        } else {
            String s = ctx.generateFormatDisplayString();
            if (s != null) {
                out.print(this.escapeHTML(s, ctx.getColumn().getType().getProcessor()));
            }
        }
        this.cellTagsClose(ctx, cell, column, out);
        out.println("</td>");
    }

    private String escapeHTML(String s, ColumnTypeProcessor type) {
        if (type instanceof ColumnTypeProcessor.ColumnTypeProcessorTypeRaw) {
            return s;
        }
        return AlocproToolkit.plainTextToHtml(s, false);
    }

    private void cellTagsOpen(@Nonnull OutputCellContext ctx, InfoCell cell, Column column, PrintWriter out) {
        if (column.isSmall()) {
            out.print("<small>");
        }
        if (column.isStrong()) {
            out.print("<strong>");
        }
        if (!ctx.getColumnProcessor().shouldBePrinted()) {
            out.print("<span class=\"naoImprime\">");
        }
        if (cell.getLink() != null) {
            this.generateLink(cell, out);
        }
    }

    private void cellTagsClose(@Nonnull OutputCellContext ctx, InfoCell cell, Column column, PrintWriter out) {
        if (cell.getLink() != null) {
            out.print("</a>");
        }
        if (!ctx.getColumnProcessor().shouldBePrinted()) {
            out.print("</span>");
        }
        if (column.isStrong()) {
            out.print("</strong>");
        }
        if (column.isSmall()) {
            out.print("</small>");
        }
    }

    private void generateLink(InfoCell cell, PrintWriter out) {
        WebRef link = cell.getLink();
        out.print("<a href=\"");
        if (link.isJs()) {
            out.print("#");
            out.print("\" onclick=\"" + link.getJs() + "return false;");
        } else {
            String url = link.getPath().getUrl(this.getUrlApp());
            if (!(url.startsWith("http") || url.startsWith(this.getUrlApp()) || url.contains("://"))) {
                out.print(this.getUrlApp());
                if (this.getUrlApp().endsWith("/") && url.startsWith("/")) {
                    out.print(url.substring(1));
                } else {
                    out.print(url);
                }
            } else {
                out.print(url);
            }
        }
        out.print('\"');
        if (cell.getLinkTarget() != null) {
            this.printAttribute("target", cell.getLinkTarget());
        }
        if (cell.getLinkTitle() != null) {
            this.printAttribute("title", cell.getLinkTitle());
        }
        out.print('>');
    }

    private String resolveCellCss(Column column, int level, boolean columnWithSeparator) {
        if (level != -1) {
            if (level <= 4) {
                return "T_DL" + level + "0";
            }
            return "T_DLN";
        }
        switch (column.getAlignment()) {
            case CENTER: {
                return columnWithSeparator ? "T_cen T_sep" : "T_cen";
            }
            case RIGHT: {
                return columnWithSeparator ? "T_dir T_sep" : "T_dir";
            }
        }
        return columnWithSeparator ? "T_sep" : null;
    }

    private static String generateActions(ViewOutputHtml out, InfoCell cell) {
        return cell.getActions().stream().filter(Predicates.notNull()).filter(WebRef::appliesToContext).map(webActionEnabled -> webActionEnabled.generateHtml(out.getUrlApp())).filter((Predicate<String>)Predicates.notNull()).collect(Collectors.joining());
    }

    final void decorateCell(@Nonnull DecoratorCell decorator) {
        if (decorator.getColSpan() > 1) {
            this.printAttribute("colspan", decorator.getColSpan());
        }
        if (decorator.getRowSpan() > 1) {
            this.printAttribute("rowspan", decorator.getRowSpan());
        }
        this.decorate(decorator);
    }

    final void decorate(@Nonnull Decorator decorator) {
        StringBuilder builder = new StringBuilder();
        this.printAttribute("class", decorator.getCssClass());
        if (!decorator.getStyles().isEmpty()) {
            this.addDecoratorStyles(decorator, builder);
        }
        if (!decorator.getAttributes().isEmpty()) {
            this.addDecoratorAttributes(decorator, builder);
        }
        if (builder.length() != 0) {
            this.print(builder.toString());
        }
    }

    private void addDecoratorStyles(@Nonnull Decorator decorator, StringBuilder builder) {
        int indexStyle = builder.indexOf("style=\"");
        if (indexStyle == -1) {
            builder.append(" style=\"");
            for (Map.Entry<String, String> style : decorator.getStyles().entrySet()) {
                builder.append(style.getKey()).append(':').append(style.getValue()).append(';');
            }
            builder.append('\"');
        } else {
            for (Map.Entry<String, String> style : decorator.getStyles().entrySet()) {
                builder.insert(indexStyle + 7, style.getKey().concat(":").concat(TableOutputHtml.stringValue(style)).concat(";"));
            }
        }
    }

    private void addDecoratorAttributes(@Nonnull Decorator decorator, StringBuilder builder) {
        for (Map.Entry<String, String> att : decorator.getAttributes().entrySet()) {
            int indexStyle;
            if ("class".equalsIgnoreCase(att.getKey())) {
                int indexClass = builder.indexOf("class=\"");
                if (indexClass > -1) {
                    indexClass = builder.substring(indexClass + 7).indexOf(34) + indexClass + 7;
                    builder.insert(indexClass, " ".concat(TableOutputHtml.stringValue(att)));
                    continue;
                }
            } else if ("style".equalsIgnoreCase(att.getKey()) && (indexStyle = builder.indexOf("style=\"")) > -1) {
                builder.insert(indexStyle + 7, " ".concat(TableOutputHtml.stringValue(att)).concat(";"));
                continue;
            }
            builder.append(' ').append(att.getKey()).append("=\"").append(att.getValue()).append('\"');
        }
    }

    private static String stringValue(Map.Entry<String, String> entry) {
        return entry.getValue() == null ? "null" : entry.getValue();
    }

    private String datatablesOptions() {
        return "{'oLanguage' : {\n    'sEmptyTable': 'Nenhum registro encontrado',\n    'sInfo': 'Mostrando de _START_ at\u00e9 _END_ de _TOTAL_ registros',\n    'sInfoEmpty': 'Mostrando 0 at\u00e9 0 de 0 registros',\n    'sInfoFiltered': '(Filtrados de _MAX_ registros)',\n    'sInfoPostFix': '',\n    'sInfoThousands': '.',\n    'sLengthMenu': '_MENU_ resultados por p\u00e1gina',\n    'sLoadingRecords': 'Carregando...',\n    'sProcessing': 'Processando...',\n    'sZeroRecords': 'Nenhum registro encontrado',\n    'sSearch': 'Pesquisar',\n    'oPaginate': {\n        'sNext': 'Pr\u00f3ximo',\n        'sPrevious': 'Anterior',\n        'sFirst': 'Primeiro',\n        'sLast': '\u00daltimo'\n    },\n    'oAria': {\n        'sSortAscending': ': Ordenar colunas de forma ascendente',\n        'sSortDescending': ': Ordenar colunas de forma descendente'\n    }\n}}";
    }
}

