/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.lib.commons.table;

import java.util.ArrayList;
import java.util.List;
import org.opensingular.lib.commons.table.InfoCell;
import org.opensingular.lib.commons.table.LineInfo;
import org.opensingular.lib.commons.table.LineReadContext;
import org.opensingular.lib.commons.table.TableTool;
import org.opensingular.lib.commons.table.TreeLineReader;

public class TablePopulator {
    private final TableTool tableTool;
    private final List<InfoCell[]> cells = new ArrayList<InfoCell[]>();
    private InfoCell last;

    public TablePopulator(TableTool tableTool) {
        this.tableTool = tableTool;
    }

    public TablePopulator insertLine() {
        this.cells.add(new InfoCell[this.tableTool.getColumns().size()]);
        this.last = null;
        return this;
    }

    public TablePopulator insertLine(Object ... values) {
        this.insertLine();
        this.setValues(values);
        return this;
    }

    public InfoCell last() {
        return this.last;
    }

    public InfoCell setValue(int pos, Object value) {
        return this.setValue(this.cells.get(this.cells.size() - 1), pos, value);
    }

    private InfoCell setValue(InfoCell[] line, int pos, Object value) {
        if (line[pos] == null) {
            line[pos] = new InfoCell(this.tableTool.getColumn(pos));
        }
        line[pos].setValue(value);
        this.last = line[pos];
        return line[pos];
    }

    public InfoCell setValues(Object ... values) {
        InfoCell[] line = this.cells.get(this.cells.size() - 1);
        for (int i = 0; i < values.length; ++i) {
            this.setValue(line, i, values[i]);
        }
        return line[values.length - 1];
    }

    public boolean isEmpty() {
        return this.cells.isEmpty();
    }

    public TreeLineReader asTreeLineReader() {
        return new TreeLineReader(){

            @Override
            public Object getRoots() {
                return TablePopulator.this.cells;
            }

            @Override
            public Object getChildren(Object item) {
                return null;
            }

            @Override
            public void retrieveValues(LineReadContext ctx, Object current, LineInfo line) {
                InfoCell[] info = (InfoCell[])current;
                if (info != null) {
                    for (int i = 0; i < info.length; ++i) {
                        if (info[i] == null) continue;
                        line.setCell(i, info[i]);
                        line.get(i).setValue(info[i].getValue());
                    }
                }
            }
        };
    }
}

