/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.lib.commons.table;

import com.google.common.base.Predicates;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensingular.lib.commons.base.SingularException;
import org.opensingular.lib.commons.table.AlocproToolkit;
import org.opensingular.lib.commons.table.Column;
import org.opensingular.lib.commons.table.ColumnAggregationType;
import org.opensingular.lib.commons.table.ColumnType;
import org.opensingular.lib.commons.table.DataReader;
import org.opensingular.lib.commons.table.DataReaderByIterator;
import org.opensingular.lib.commons.table.Decorator;
import org.opensingular.lib.commons.table.DecoratorCell;
import org.opensingular.lib.commons.table.GenerationModifier;
import org.opensingular.lib.commons.table.GenerationModifierAggregate;
import org.opensingular.lib.commons.table.GenerationModifierAgrupar;
import org.opensingular.lib.commons.table.GenerationModifierFilter;
import org.opensingular.lib.commons.table.GenerationModifierGroupingWithAggregation;
import org.opensingular.lib.commons.table.GenerationModifierOrder;
import org.opensingular.lib.commons.table.GeneratorUtil;
import org.opensingular.lib.commons.table.InfoCell;
import org.opensingular.lib.commons.table.LineData;
import org.opensingular.lib.commons.table.LineInfo;
import org.opensingular.lib.commons.table.LineReader;
import org.opensingular.lib.commons.table.OutputCellContext;
import org.opensingular.lib.commons.table.OutputTableContext;
import org.opensingular.lib.commons.table.TableOutput;
import org.opensingular.lib.commons.table.TablePopulator;
import org.opensingular.lib.commons.table.TableToolUtil;
import org.opensingular.lib.commons.table.TreeLineReader;
import org.opensingular.lib.commons.views.ViewGenerator;
import org.opensingular.lib.commons.views.ViewGeneratorProvider;
import org.opensingular.lib.commons.views.ViewMultiGenerator;
import org.opensingular.lib.commons.views.ViewOutput;

public final class TableTool
implements ViewMultiGenerator,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<Column> columns = new ArrayList<Column>();
    private TreeLineReader reader;
    private boolean tableByLevel;
    private boolean simpleTable;
    private boolean hasSuperTitles = false;
    private int levelLimit;
    private String align;
    private String width;
    private boolean showTitles = true;
    private int initialLevel;
    private int indentedColumn;
    private boolean strippedLines = true;
    private List<GenerationModifier> modifiers = new ArrayList<GenerationModifier>();
    private boolean showTotalLine;
    private Integer totalLevel = 0;
    private transient LineInfo totalLine;
    private String id;
    private Decorator decorator = new Decorator();

    public TableTool() {
    }

    public TableTool(String id) {
        this.id = id;
    }

    @Nonnull
    public Column addColumn(@Nonnull ColumnType type, @Nullable String title) {
        Column column = new Column(type);
        column.setTitle(title);
        column.setIndex(this.columns.size());
        this.columns.add(column);
        return column;
    }

    @Nonnull
    public Column addColumn(@Nonnull ColumnType type) {
        return this.addColumn(type, null);
    }

    public void addSuperTitle(int startColumn, int endColumn, String superTitle) {
        this.addSuperTitle(startColumn, endColumn, superTitle, true);
    }

    public void addSuperTitle(int startColumn, int endColumn, String superTitle, boolean separator) {
        this.hasSuperTitles = true;
        for (int i = startColumn; i <= endColumn; ++i) {
            Column c = this.columns.get(i);
            c.setSuperTitle(superTitle);
            if (i != startColumn) continue;
            c.setHasSeparator(separator);
        }
    }

    public TableTool addGroupBy(String columnTitle) {
        this.addOrderBy(columnTitle);
        Column c = this.getColumn(columnTitle);
        this.addModifier(new GenerationModifierAgrupar(this, c));
        return this;
    }

    public TableTool addOrderBy(String columnTitle) {
        return this.addOrderBy(columnTitle, false);
    }

    public TableTool addOrderBy(String columnTitle, boolean descending) {
        return this.addOrderBy(this.getColumn(columnTitle), descending);
    }

    public TableTool addOrderBy(int columnIndex) {
        return this.addOrderBy(columnIndex, false);
    }

    public TableTool addOrderBy(int columnIndex, boolean descending) {
        return this.addOrderBy(this.getColumn(columnIndex), descending);
    }

    public TableTool addOrderBy(Column column, boolean descending) {
        Optional order = this.modifiers.stream().filter(Predicates.instanceOf(GenerationModifierOrder.class)).findFirst();
        if (order.isPresent()) {
            ((GenerationModifierOrder)order.get()).addColumn(column);
        } else {
            this.addModifier(new GenerationModifierOrder(this, column, descending));
        }
        return this;
    }

    public TableTool addAggregation(Column column, ColumnAggregationType columnAggregationType) {
        this.findOrAddModifier(GenerationModifierAggregate.class, () -> new GenerationModifierAggregate(this)).addColumn(column, columnAggregationType);
        return this;
    }

    public TableTool addAggregation(Column column, Object value) {
        this.findOrAddModifier(GenerationModifierAggregate.class, () -> new GenerationModifierAggregate(this)).setColumnExternalResult(column, value);
        return this;
    }

    public TableTool addFilter(Column column, Predicate<InfoCell> filter) {
        this.findOrAddModifier(GenerationModifierFilter.class, () -> new GenerationModifierFilter(this)).addColumn(column, filter);
        return this;
    }

    public TableTool configAggregation(Map<Column, ColumnAggregationType> aggregationConfig) {
        this.findOrAddModifier(GenerationModifierGroupingWithAggregation.class, () -> new GenerationModifierGroupingWithAggregation(this, aggregationConfig));
        return this;
    }

    public TableTool addAGroupingWothAggregation(Column column) {
        this.findOrAddModifier(GenerationModifierGroupingWithAggregation.class, () -> new GenerationModifierGroupingWithAggregation(this)).addColumn(column);
        return this;
    }

    public Decorator getDecorator() {
        return this.decorator;
    }

    public <T extends GenerationModifier> T findOrAddModifier(Class<T> modifier, Supplier<T> newModifier) {
        Optional find = this.modifiers.stream().filter(Predicates.instanceOf(modifier)).findFirst();
        return (T)find.orElseGet(() -> this.addModifier((GenerationModifier)newModifier.get()));
    }

    public <T extends GenerationModifier> T addModifier(T m) {
        if (!this.modifiers.isEmpty()) {
            this.modifiers.get(0).addFimCadeia(m);
        }
        this.modifiers.add(m);
        return m;
    }

    public void setLevelLimit(int levelLimit) {
        this.levelLimit = levelLimit;
    }

    public String getAlign() {
        return this.align;
    }

    public void setAlign(String align) {
        this.align = align;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public boolean isShowTitles() {
        return this.showTitles;
    }

    boolean isSimpleTable() {
        return this.simpleTable;
    }

    public void setShowTitles(boolean showTitles) {
        this.showTitles = showTitles;
    }

    public void setShowTotalLine(boolean showTotalLine) {
        this.showTotalLine = showTotalLine;
    }

    public boolean isShowTotalLine() {
        return this.showTotalLine;
    }

    public void setTotalLevel(Integer totalLevel) {
        this.totalLevel = totalLevel;
    }

    public boolean isStrippedLines() {
        return this.strippedLines;
    }

    public void setStrippedLines(boolean strippedLines) {
        this.strippedLines = strippedLines;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public Column getColumn(int index) {
        return this.columns.get(index);
    }

    public Column getColumn(String titleOrId) {
        return this.columns.stream().filter(c -> titleOrId.equalsIgnoreCase(c.getTitle())).findFirst().orElseGet(() -> this.columns.stream().filter(c -> titleOrId.equalsIgnoreCase(c.getId())).findFirst().orElse(null));
    }

    public void setInitialLevel(int initialLevel) {
        this.initialLevel = initialLevel;
    }

    private List<Column> calculateVisibleColumns(OutputTableContext ctx) {
        ArrayList<Column> visible = new ArrayList<Column>(this.columns.size());
        String superTitle = null;
        boolean addedSuperTitleGroupSeparator = false;
        for (int i = 0; i < this.columns.size(); ++i) {
            Column c = this.columns.get(i);
            if (!this.shouldShowColumn(ctx, c)) continue;
            if (!Objects.equals(superTitle, c.getSuperTitle())) {
                if (c.hasSeparator()) {
                    this.addColumnSeparator(visible);
                    superTitle = c.getSuperTitle();
                    addedSuperTitleGroupSeparator = c.getSuperTitle() != null;
                } else if (c.getSuperTitle() == null && addedSuperTitleGroupSeparator) {
                    this.addColumnSeparator(visible);
                    superTitle = null;
                    addedSuperTitleGroupSeparator = false;
                } else {
                    superTitle = null;
                    addedSuperTitleGroupSeparator = false;
                }
            } else if (c.hasSeparator()) {
                this.addColumnSeparator(visible);
            }
            visible.add(c);
        }
        return visible;
    }

    private boolean shouldShowColumn(OutputTableContext ctx, Column c) {
        return c.isVisible() && (c.getProcessor().shouldBeGeneretedOnStaticContent() || !ctx.isStaticContent());
    }

    private void addColumnSeparator(List<Column> visible) {
        if (!visible.isEmpty()) {
            visible.add(null);
        }
    }

    public TablePopulator createSimpleTablePopulator() {
        TablePopulator populator = new TablePopulator(this);
        this.reader = populator.asTreeLineReader();
        this.simpleTable = true;
        return populator;
    }

    public <T> void setReaderByLine(Iterable<? extends T> list, LineReader<T> reader) {
        this.reader = GeneratorUtil.toTreeLineReader(list, reader);
        this.simpleTable = true;
    }

    public void setReaderByTree(TreeLineReader reader) {
        this.reader = reader;
        this.simpleTable = false;
    }

    public void setReaderByLevel(TreeLineReader reader) {
        this.reader = reader;
        this.tableByLevel = true;
    }

    public void setIndentedColumn(int indentedColumn) {
        this.indentedColumn = indentedColumn;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void generate(@Nonnull TableOutput tableOutput) {
        if (this.getColumns().isEmpty()) {
            return;
        }
        this.totalLine = this.newBlankLine();
        DataReader dataReader = new DataReaderByIterator(this.reader, this.reader.getRoots(), 0);
        if (!this.isShowTitles() && ((DataReader)dataReader).isEmpty()) {
            return;
        }
        OutputTableContext ctx = new OutputTableContext(this, tableOutput);
        ctx.setVisibleColumns(this.calculateVisibleColumns(ctx));
        ctx.getOutput().generateTableStart(ctx, this);
        if (!this.modifiers.isEmpty()) {
            ctx.setVisibleColumns(this.modifiers.get(0).adjustTitles(ctx.getVisibleColumns()));
            this.generateTitles(ctx);
            dataReader = this.modifiers.get(0).apply(dataReader);
        } else {
            this.generateTitles(ctx);
        }
        this.generateChildren(dataReader, ctx, this.initialLevel);
        if (this.showTotalLine) {
            this.generateTotalLine(ctx);
        }
        ctx.getOutput().generateTableEnd(ctx, this);
    }

    private void generateTitles(OutputTableContext ctx) {
        if (this.isShowTitles() || this.hasSuperTitles) {
            ctx.getOutput().generateTitleBlockStart(ctx);
            if (this.hasSuperTitles) {
                this.generateSuperTitles(ctx);
            }
            if (this.isShowTitles()) {
                this.generateNormalTitles(ctx);
            }
            ctx.getOutput().generateTitleBlockEnd(ctx);
        }
    }

    private void generateNormalTitles(OutputTableContext ctx) {
        List<Column> visible = ctx.getVisibleColumns();
        ctx.getOutput().generateTitleLineStart(ctx, false);
        boolean nextColumnWithSeparator = false;
        for (Column column : visible) {
            if (column == null) {
                nextColumnWithSeparator = true;
                continue;
            }
            if (column.getSuperTitle() == null && this.hasSuperTitles) continue;
            ctx.getOutput().generateTitleCell(ctx, column, 1, this.hasSuperTitles, nextColumnWithSeparator);
            nextColumnWithSeparator = false;
        }
        ctx.getOutput().generateTitleLineEnd(ctx, false);
    }

    private void generateSuperTitles(OutputTableContext ctx) {
        List<Column> visible = ctx.getVisibleColumns();
        ctx.getOutput().generateTitleLineStart(ctx, true);
        boolean nextColumnWithSeparator = false;
        for (int i = 0; i < visible.size(); ++i) {
            Column c = visible.get(i);
            if (c == null) {
                nextColumnWithSeparator = true;
                continue;
            }
            if (c.getSuperTitle() == null) {
                ctx.getOutput().generateTitleCell(ctx, c, 2, false, nextColumnWithSeparator);
                nextColumnWithSeparator = false;
                continue;
            }
            int ult = i;
            while (ult + 1 < visible.size() && visible.get(ult + 1) != null && Objects.equals(visible.get(ult + 1).getSuperTitle(), c.getSuperTitle())) {
                ++ult;
            }
            ctx.getOutput().generateTitleCellSuper(ctx, c, ult - i + 1, nextColumnWithSeparator);
            nextColumnWithSeparator = false;
            i = ult;
        }
        ctx.getOutput().generateTitleLineEnd(ctx, true);
    }

    final LineInfo newBlankLine() {
        return new LineInfo(this);
    }

    private void generateChildren(DataReader children, OutputTableContext ctx, int level) {
        if (children == null || children.isEmpty()) {
            return;
        }
        ctx.getOutput().generateBodyBlockStart(ctx);
        if (this.tableByLevel || this.columns.stream().anyMatch(c -> c.getDataLevel() > 0)) {
            int qtdLevel = this.columns.stream().mapToInt(c -> c.getDataLevel()).max().getAsInt() + 1;
            int[] lineCount = new int[qtdLevel];
            for (LineData child : children) {
                for (LineData[] line : child.normalizeLevels(qtdLevel)) {
                    this.generateTableByLevel(line, ctx, lineCount);
                }
            }
        } else {
            for (LineData lineData : children) {
                if (this.simpleTable) {
                    this.generateSimpleTable(lineData, ctx);
                    continue;
                }
                this.generateTreeLine(lineData, ctx, level);
            }
        }
        ctx.getOutput().generateBodyBlockEnd(ctx);
    }

    private void generateTableByLevel(LineData[] lineData, OutputTableContext ctx, int[] lineCounter) {
        int lineLevel = -1;
        int lineColor = 0;
        LineInfo lineInfo = null;
        for (int i = 0; i < lineData.length; ++i) {
            if (lineData[i] == null) continue;
            if (lineLevel == -1) {
                lineLevel = i;
                int n = i;
                lineCounter[n] = lineCounter[n] + 1;
                for (int j = i + 1; j < lineCounter.length; ++j) {
                    lineCounter[j] = lineCounter[i];
                }
                lineColor = lineCounter[i];
            }
            ctx.getLineReadContext().setLevel(lineLevel);
            lineInfo = lineData[i].retrieveValues(ctx.getLineReadContext(), i, lineLevel == i, false);
        }
        if (lineInfo == null) {
            throw new SingularException("Invalid State");
        }
        if (ctx.isShowLine()) {
            this.generateTableByLevelLine(lineData, ctx, lineInfo, lineLevel, lineColor);
        }
    }

    private void generateTableByLevelLine(LineData[] lineData, OutputTableContext ctx, LineInfo line, int lineLevel, int lineColor) {
        int qtdSpan;
        int lineAlternation = this.isStrippedLines() ? lineColor : -1;
        ctx.getOutput().generateLineSimpleStart(ctx, line, lineAlternation);
        boolean nextColumnWithSeparator = false;
        for (int columnIndex = 0; columnIndex < ctx.getVisibleColumns().size(); columnIndex += qtdSpan) {
            Column c = ctx.getVisibleColumns().get(columnIndex);
            ctx.setIndexCurrentColumn(columnIndex);
            qtdSpan = 1;
            if (c == null) {
                if (lineData[0] == null) continue;
                nextColumnWithSeparator = true;
                continue;
            }
            if (c.getDataLevel() < lineLevel) continue;
            int level = c.getDataLevel();
            InfoCell cell = line.get(c);
            OutputCellContext ctxCell = this.createCellContext(ctx, cell, nextColumnWithSeparator);
            nextColumnWithSeparator = false;
            if (lineData[level] != null) {
                int rowSpan = lineData[level].getLines();
                ctxCell.getTempDecorator().setRowSpan(rowSpan);
            }
            if (ctxCell.getTempDecorator().getRowSpan() != 0) {
                ctxCell.setLevel(this.indentedColumn == columnIndex ? level : -1);
                ctx.getOutput().generateCell(ctxCell);
            }
            this.addToTotal(c, cell, level);
            qtdSpan = ctxCell.getTempDecorator().getColSpan();
        }
        ctx.getOutput().generateLineSimpleEnd(ctx);
        ctx.incIndexCurrentLine();
    }

    private Decorator resolverDecorator(OutputTableContext ctx, LineInfo line) {
        return line.createTempDecorator();
    }

    private void generateTreeLine(LineData lineData, OutputTableContext ctx, int level) {
        if (this.levelLimit > 0 && level + 1 > this.levelLimit) {
            return;
        }
        ctx.getLineReadContext().setLevel(level);
        LineInfo line = lineData.retrieveValues(ctx.getLineReadContext(), level, true, false);
        if (!ctx.isShowLine()) {
            this.generateChildren(lineData.getChildrenReader(), ctx, level);
            return;
        }
        ctx.getOutput().generateLineTreeStart(ctx, line, level);
        int columnIndex = 0;
        boolean nextColumnWithSeparator = false;
        while (columnIndex < ctx.getVisibleColumns().size()) {
            Column c = ctx.getVisibleColumns().get(columnIndex);
            ctx.setIndexCurrentColumn(columnIndex);
            if (c == null) {
                nextColumnWithSeparator = true;
                ++columnIndex;
                continue;
            }
            InfoCell cell = line.get(c);
            if (level == 0 && c.isShowAsPercentageOfParent()) {
                c.setValueForPercentageCalculation(cell.getValueAsNumberOrNull());
            }
            OutputCellContext ctxCell = this.createCellContext(ctx, cell, nextColumnWithSeparator);
            nextColumnWithSeparator = false;
            ctxCell.setLevel(this.indentedColumn == columnIndex ? level : -1);
            if (ctxCell.getTempDecorator().getRowSpan() != 0) {
                ctx.getOutput().generateCell(ctxCell);
            }
            this.addToTotal(c, cell, level);
            columnIndex += ctxCell.getTempDecorator().getColSpan();
        }
        ctx.getOutput().generateLineTreeEnd(ctx);
        ctx.incIndexCurrentLine();
        this.generateChildren(lineData.getChildrenReader(), ctx, level + 1);
    }

    private void generateSimpleTable(LineData lineData, OutputTableContext ctx) {
        LineInfo line = lineData.retrieveValues(ctx.getLineReadContext(), 0, true, false);
        if (!ctx.isShowLine()) {
            return;
        }
        int lineAlternation = this.isStrippedLines() ? ctx.getIndexCurrentLine() % 2 : -1;
        ctx.getOutput().generateLineSimpleStart(ctx, line, lineAlternation);
        int columnIndex = 0;
        boolean nextColumnWithSeparator = false;
        while (columnIndex < ctx.getVisibleColumns().size()) {
            Column c = ctx.getVisibleColumns().get(columnIndex);
            ctx.setIndexCurrentColumn(columnIndex);
            if (c == null) {
                nextColumnWithSeparator = true;
                ++columnIndex;
                continue;
            }
            InfoCell cell = line.get(c);
            if (c.isShowAsPercentageOfParent()) {
                c.setValueForPercentageCalculation(cell.getValueAsNumberOrNull());
            }
            OutputCellContext ctxCell = this.createCellContext(ctx, cell, nextColumnWithSeparator);
            nextColumnWithSeparator = false;
            ctxCell.setLevel(-1);
            if (ctxCell.getTempDecorator().getRowSpan() != 0) {
                ctx.getOutput().generateCell(ctxCell);
            }
            this.addToTotal(c, cell, 0);
            columnIndex += ctxCell.getTempDecorator().getColSpan();
        }
        ctx.getOutput().generateLineSimpleEnd(ctx);
        ctx.incIndexCurrentLine();
    }

    @Nonnull
    private OutputCellContext createCellContext(OutputTableContext ctx, InfoCell cell, boolean columnWithSeparator) {
        OutputCellContext ctxCell;
        DecoratorCell decorator = cell.createTempDecorator();
        if (decorator.isColSpanAll()) {
            decorator.setColSpan(ctx.getVisibleColumnsSize() - ctx.getIndexCurrentColumn());
        }
        if ((ctxCell = new OutputCellContext(ctx, cell, decorator)).getColumn().isShowAsPercentageOfParent()) {
            ctxCell.setColumnProcessor(ColumnType.PERCENT.getProcessor());
            if (ctxCell.getValue() instanceof Number) {
                Number value = (Number)ctxCell.getValue();
                value = AlocproToolkit.divide(value, ctxCell.getColumn().getValueForPercentageCalculation());
                ctxCell.setValue(value);
            }
        }
        ctxCell.setColumnWithSeparator(columnWithSeparator);
        return ctxCell;
    }

    private void addToTotal(Column c, InfoCell cell, int level) {
        if (this.showTotalLine && c.isTotalize() && (this.totalLevel == null || level == this.totalLevel)) {
            InfoCell total = this.totalLine.get(c);
            Number value = null;
            if (cell.getValue() instanceof Number) {
                value = (Number)cell.getValue();
            } else if (cell.getValueReal() instanceof Number) {
                value = (Number)((Object)cell.getValueReal());
            }
            total.setValue(AlocproToolkit.add(total.getValueAsNumberOrNull(), value));
        }
    }

    private void generateTotalLine(OutputTableContext ctx) {
        Decorator tmpDecorator = this.resolverDecorator(ctx, this.totalLine);
        ctx.getOutput().generateTotalBlockStart(ctx);
        if (ctx.getTableTool().isSimpleTable()) {
            ctx.getOutput().generateTotalLineStart(ctx, this.totalLine, tmpDecorator, -1);
        } else {
            ctx.getOutput().generateTotalLineStart(ctx, this.totalLine, tmpDecorator, this.initialLevel);
        }
        int columnIndex = 0;
        boolean nextColumnWithSeparator = false;
        for (Column c : ctx.getVisibleColumns()) {
            if (c == null) {
                nextColumnWithSeparator = true;
            } else if (!c.isTotalize()) {
                ctx.getOutput().generateTotalCellSkip(ctx, c, nextColumnWithSeparator);
                nextColumnWithSeparator = false;
            } else if (columnIndex == 0) {
                DecoratorCell tmpDecoratorCell = new DecoratorCell(c.getDecoratorValues());
                ctx.getOutput().generateTotalLabel(ctx, c, "Total", tmpDecoratorCell, this.initialLevel);
            } else {
                InfoCell cell = this.totalLine.get(c);
                OutputCellContext ctxCell = new OutputCellContext(ctx, cell, cell.createTempDecorator()).setLevel(-1);
                ctxCell.setColumnWithSeparator(nextColumnWithSeparator);
                Number value = cell.getValueAsNumberOrNull();
                ctx.getOutput().generateTotalCell(ctxCell, value);
                nextColumnWithSeparator = false;
            }
            ++columnIndex;
        }
        ctx.getOutput().generateTotalLineEnd(ctx);
        ctx.getOutput().generateTotalBlockEnd(ctx);
    }

    @Override
    @Nonnull
    public Collection<ViewGeneratorProvider<ViewGenerator, ? extends ViewOutput<?>>> getGenerators() {
        return TableToolUtil.getGenerators();
    }
}

