/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.lib.commons.test;

import java.util.Optional;
import javax.annotation.Nonnull;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.description.Description;

public abstract class AssertionsBase<SELF extends AssertionsBase<SELF, T>, T>
extends AbstractAssert<SELF, T> {
    public AssertionsBase(T target) {
        super(target, AssertionsBase.class);
        this.as(new DescriptionForTarget(this));
    }

    public AssertionsBase(Optional<? extends T> target) {
        this(target.orElse(null));
    }

    @Nonnull
    public final T getTarget() {
        this.isNotNull();
        return (T)this.actual;
    }

    @Nonnull
    public final Optional<T> getTargetOpt() {
        return Optional.ofNullable(this.actual);
    }

    @Nonnull
    public final <TT> TT getTarget(@Nonnull Class<TT> expectedClass) {
        this.isInstanceOf(expectedClass);
        return expectedClass.cast(this.getTarget());
    }

    @Nonnull
    protected Optional<String> generateDescriptionForCurrentTarget(@Nonnull Optional<T> current) {
        return Optional.empty();
    }

    protected final String errorMsg(String msg) {
        return this.errorMsg(msg, null, null);
    }

    protected final String errorMsg(String msg, Object expected, Object current) {
        Optional<String> targetDescription;
        boolean showClass = expected != null && current != null && expected.getClass() != current.getClass();
        boolean bl = "null".equals(expected) || "null".equals(current);
        StringBuilder sb = new StringBuilder();
        sb.append(msg).append(":\n Esperado  : ").append(expected);
        if ((showClass |= bl) && expected != null) {
            sb.append(" (").append(expected.getClass()).append(')');
        }
        sb.append("\n Encontrado: ").append(current);
        if (showClass && current != null) {
            sb.append(" (").append(current.getClass()).append(')');
        }
        return (targetDescription = this.generateDescriptionForCurrentTarget(this.getTargetOpt())).isPresent() ? "[" + targetDescription.get() + "]: " + sb : sb.toString();
    }

    private static class DescriptionForTarget<T>
    extends Description {
        private final AssertionsBase<?, T> assertionsBase;

        private DescriptionForTarget(@Nonnull AssertionsBase<?, T> assertionsBase) {
            this.assertionsBase = assertionsBase;
        }

        public String value() {
            return this.assertionsBase.generateDescriptionForCurrentTarget(this.assertionsBase.getTargetOpt()).orElse("");
        }
    }
}

