/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.lib.commons.util;

import java.text.SimpleDateFormat;
import java.util.Date;

public final class FormatUtil {
    private FormatUtil() {
    }

    public static String dateToDefaultTimestampString(Date date) {
        return new SimpleDateFormat("dd/MM/yyyy HH:mm").format(date);
    }

    public static String dateToDefaultDateString(Date date) {
        return new SimpleDateFormat("dd/MM/yyyy").format(date);
    }

    public static StringBuilder appendSeconds(StringBuilder time, long seconds) {
        if (seconds > 0L) {
            if (seconds < 60L) {
                time.append(seconds);
            } else {
                FormatUtil.appendMinutes(time, seconds / 60L);
                time.append(seconds % 60L);
            }
            time.append(" s ");
        }
        return time;
    }

    public static StringBuilder appendMinutes(StringBuilder time, long minutes) {
        if (minutes > 0L) {
            if (minutes < 60L) {
                time.append(minutes);
            } else {
                FormatUtil.appendHours(time, minutes / 60L);
                time.append(minutes % 60L);
            }
            time.append(" min ");
        }
        return time;
    }

    public static StringBuilder appendHours(StringBuilder time, long hours) {
        if (hours > 0L) {
            if (hours < 24L) {
                time.append(hours);
            } else {
                FormatUtil.appendDays(time, hours / 24L);
                time.append(hours % 24L);
            }
            time.append(" h ");
        }
        return time;
    }

    public static StringBuilder appendDays(StringBuilder time, long days) {
        if (days > 0L) {
            time.append(days).append(" d ");
        }
        return time;
    }

    public static String booleanDescription(Boolean value, String trueDescription, String falseDescription) {
        return FormatUtil.booleanDescription(value, trueDescription, falseDescription, "");
    }

    public static String booleanDescription(Boolean value, String trueDescription, String falseDescription, String nullDescription) {
        if (value == null) {
            return nullDescription;
        }
        return value != false ? trueDescription : falseDescription;
    }
}

