/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.lib.commons.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.opensingular.lib.commons.base.SingularException;

public abstract class TempFileUtils {
    public static final String PREFIX = "stream2file";
    public static final String SUFFIX = ".tmp";

    private TempFileUtils() {
    }

    private static boolean exists(File f) {
        return f != null && f.exists();
    }

    public static void deleteAndFailQuietily(@Nonnull File file, @Nonnull Object requester) {
        TempFileUtils.delete(file, requester, true);
    }

    public static void deleteOrException(@Nonnull File file, @Nonnull Object requester) {
        TempFileUtils.delete(file, requester, false);
    }

    private static void delete(@Nonnull File file, @Nonnull Object requester, boolean failQuietly) {
        Objects.requireNonNull(requester);
        if (file.exists()) {
            try {
                if (!file.delete()) {
                    TempFileUtils.dealWithDeleteError(file, requester, failQuietly, null);
                }
            }
            catch (Exception e) {
                TempFileUtils.dealWithDeleteError(file, requester, failQuietly, e);
            }
        }
    }

    private static void dealWithDeleteError(@Nonnull File file, @Nonnull Object requester, boolean failQuietly, @Nullable Exception e) {
        Class<?> req = requester instanceof Class ? (Class<?>)requester : requester.getClass();
        String msg = "Nao foi poss\u00edvel apagar o arquivo " + file;
        msg = msg + " (solicita\u00e7\u00e3o da classe " + req.getName() + ")";
        if (!failQuietly) {
            throw SingularException.rethrow(msg, e);
        }
        Logger logger = Logger.getLogger(req.getName());
        logger.log(Level.SEVERE, msg, e);
    }

    public static File stream2file(InputStream in) throws IOException {
        File tempFile = File.createTempFile(PREFIX, SUFFIX);
        tempFile.deleteOnExit();
        IOUtils.copy((InputStream)in, (OutputStream)new FileOutputStream(tempFile));
        return tempFile;
    }

    public static File decodeToTempFile(String base64String) throws IOException {
        byte[] binaryDate = Base64.decodeBase64((String)base64String);
        return TempFileUtils.createTempFile(binaryDate);
    }

    public static File transferToTempFile(String value) throws IOException {
        byte[] binaryDate = value.getBytes(Charset.forName("UTF-8"));
        return TempFileUtils.createTempFile(binaryDate);
    }

    public static File createTempFile(byte[] binaryDate) throws IOException {
        File tempFile = File.createTempFile("file", "tmp");
        TempFileUtils.writeByteArrayToFile(tempFile, binaryDate);
        return tempFile;
    }

    public static void writeByteArrayToFile(File file, byte[] bytes) throws IOException {
        FileUtils.writeByteArrayToFile((File)file, (byte[])bytes);
    }
}

