/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.lib.commons.util;

import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.xml.ws.BindingProvider;
import org.opensingular.lib.commons.base.SingularProperties;
import org.opensingular.lib.commons.util.WSClientSafeWrapper;
import org.opensingular.lib.commons.util.WSConnectionException;

public class WSClientDefaultFactory<T>
implements WSClientSafeWrapper.WSClientFactory<T> {
    private String property;
    private Supplier<T> supplier;

    public WSClientDefaultFactory(String property, Supplier<T> portTypeSupplier) {
        this.property = property;
        this.supplier = portTypeSupplier;
    }

    public WSClientDefaultFactory(Supplier<T> portTypeSupplier) {
        this(null, portTypeSupplier);
    }

    @Override
    public T getReference() {
        T servicePortType = this.supplier.get();
        if (this.property != null) {
            this.changeTargetEndpointAddress(servicePortType);
        }
        return servicePortType;
    }

    private void changeTargetEndpointAddress(T servicePortType) {
        Optional<String> propertyValue = SingularProperties.getOpt(this.property);
        if (!propertyValue.isPresent()) {
            throw new WSConnectionException(String.format("WebService endpoint property not found in SingularProperties. Missing property %s", this.property));
        }
        String value = propertyValue.get();
        if (value.endsWith("?wsdl")) {
            value = value.substring(0, value.length() - "?wsdl".length());
        }
        Map requestContext = ((BindingProvider)servicePortType).getRequestContext();
        requestContext.put("javax.xml.ws.service.endpoint.address", value);
        requestContext.put("set-jaxb-validation-event-handler", Boolean.FALSE);
    }
}

