/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.lib.commons.views;

import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.opensingular.lib.commons.views.SingularViewUnsupportedFormatException;
import org.opensingular.lib.commons.views.ViewGenerator;
import org.opensingular.lib.commons.views.ViewGeneratorProvider;
import org.opensingular.lib.commons.views.ViewOutput;
import org.opensingular.lib.commons.views.ViewOutputFormat;
import org.opensingular.lib.commons.views.ViewsUtil;

public interface ViewMultiGenerator
extends ViewGenerator {
    @Nonnull
    public Collection<ViewGeneratorProvider<ViewGenerator, ? extends ViewOutput<?>>> getGenerators();

    @Nonnull
    default public Collection<ViewOutputFormat> getDirectSupportedFormats() {
        return this.getGenerators().stream().map(ViewGeneratorProvider::getOutputFormat).collect(Collectors.toList());
    }

    @Override
    default public void generateView(@Nonnull ViewOutput<?> vOut) throws SingularViewUnsupportedFormatException {
        this.getGeneratorFor(vOut).generateView(vOut);
    }

    @Override
    default public boolean isDirectCompatibleWith(@Nonnull ViewOutputFormat format) {
        return this.getGenerators().stream().anyMatch(p -> Objects.equals(format, p.getOutputFormat()));
    }

    @Nonnull
    default public ViewGenerator getGeneratorFor(@Nonnull ViewOutput<?> vOut) {
        return this.getGeneratorFor(vOut.getFormat());
    }

    @Nonnull
    default public ViewGenerator getGeneratorFor(@Nonnull ViewOutputFormat format) {
        return ViewsUtil.getGeneratorFor(this, format);
    }
}

