/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.lib.commons.views;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Objects;
import java.util.ServiceLoader;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensingular.internal.lib.commons.util.TempFileProvider;
import org.opensingular.lib.commons.util.TempFileUtils;
import org.opensingular.lib.commons.views.SingularViewException;
import org.opensingular.lib.commons.views.SingularViewUnsupportedFormatException;
import org.opensingular.lib.commons.views.ViewGenerator;
import org.opensingular.lib.commons.views.ViewGeneratorProvider;
import org.opensingular.lib.commons.views.ViewMultiGenerator;
import org.opensingular.lib.commons.views.ViewOutput;
import org.opensingular.lib.commons.views.ViewOutputFormat;
import org.opensingular.lib.commons.views.ViewOutputFormatExportable;
import org.opensingular.lib.commons.views.format.ViewOutputHtmlWriterWrap;

public class ViewsUtil {
    private static ServiceLoader<ViewOutputFormat> formatsLoader;

    private static ServiceLoader<ViewOutputFormat> getFormatsLoader() {
        if (formatsLoader == null) {
            formatsLoader = ServiceLoader.load(ViewOutputFormat.class);
        }
        return formatsLoader;
    }

    @Nonnull
    static ViewGenerator getGeneratorFor(final @Nonnull ViewMultiGenerator target, final @Nonnull ViewOutputFormat format) throws SingularViewUnsupportedFormatException {
        final ViewGeneratorProvider provider = ViewsUtil.getGeneratorProviderFor(target, format);
        return new ViewGenerator(){

            @Override
            public void generateView(@Nonnull ViewOutput<?> vOut) throws SingularViewUnsupportedFormatException {
                provider.generate(target, vOut);
            }

            @Override
            public boolean isDirectCompatibleWith(@Nonnull ViewOutputFormat format2) {
                return format.equals(format2);
            }
        };
    }

    @Nonnull
    private static <V extends ViewOutput<?>> ViewGeneratorProvider<ViewGenerator, V> getGeneratorProviderFor(@Nonnull ViewMultiGenerator target, @Nonnull ViewOutputFormat format) throws SingularViewUnsupportedFormatException {
        for (ViewGeneratorProvider<ViewGenerator, ViewOutput<?>> generator : target.getGenerators()) {
            if (!Objects.equals(format, generator.getOutputFormat())) continue;
            return generator;
        }
        throw new SingularViewUnsupportedFormatException((Object)target, format);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String generateAsHtmlString(ViewGenerator target, boolean staticContent) {
        try (StringWriter out = new StringWriter();){
            ViewOutputHtmlWriterWrap vOut = new ViewOutputHtmlWriterWrap(out, staticContent);
            target.generateView(vOut);
            String string = out.toString();
            return string;
        }
        catch (IOException e) {
            throw new SingularViewException(e);
        }
    }

    @Nullable
    private ViewGenerator findDirectCompatiable(@Nonnull ViewGenerator viewGenerator, @Nonnull ViewOutputFormatExportable format) {
        if (viewGenerator.isDirectCompatibleWith(format)) {
            return viewGenerator;
        }
        if (viewGenerator instanceof ViewMultiGenerator) {
            return ViewsUtil.getGeneratorFor((ViewMultiGenerator)viewGenerator, format);
        }
        throw new SingularViewUnsupportedFormatException((Object)viewGenerator, format);
    }

    @Nonnull
    public static File exportToTempFile(@Nonnull ViewGenerator viewGenerator, @Nonnull ViewOutputFormatExportable format) {
        return ViewsUtil.exportToTempFile(viewGenerator, format, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static File exportToTempFile(@Nonnull ViewGenerator viewGenerator, @Nonnull ViewOutputFormatExportable format, @Nullable TempFileProvider tmpProvider) {
        ViewGenerator copyOfViewGenerator = viewGenerator;
        if (!copyOfViewGenerator.isDirectCompatibleWith(format)) {
            if (copyOfViewGenerator instanceof ViewMultiGenerator) {
                copyOfViewGenerator = ViewsUtil.getGeneratorFor((ViewMultiGenerator)copyOfViewGenerator, format);
            }
            throw new SingularViewUnsupportedFormatException((Object)copyOfViewGenerator, format);
        }
        try {
            File arq = tmpProvider == null ? File.createTempFile(ViewsUtil.class.getSimpleName() + "_report", "." + format.getFileExtension()) : tmpProvider.createTempFile(ViewsUtil.class.getSimpleName() + "_report", "." + format.getFileExtension());
            boolean ok = false;
            try {
                format.generateFile(arq, copyOfViewGenerator);
                ok = true;
            }
            finally {
                if (!ok) {
                    TempFileUtils.deleteAndFailQuietily(arq, ViewsUtil.class);
                }
            }
            return arq;
        }
        catch (Exception e) {
            throw new SingularViewException("Fail to generate file in " + format.getName() + " format", e);
        }
    }
}

