/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.lib.commons.views.format;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.opensingular.lib.commons.base.SingularException;

public class FullPageHtmlGenerator
implements Closeable {
    private final PrintWriter out;
    private final List<URL> internalCSS = new ArrayList<URL>();

    public FullPageHtmlGenerator(@Nonnull File outputFile) throws IOException {
        this.out = new PrintWriter(new FileOutputStream(outputFile));
    }

    public FullPageHtmlGenerator(@Nonnull PrintWriter out) {
        this.out = Objects.requireNonNull(out);
    }

    public FullPageHtmlGenerator(@Nonnull Writer out) {
        this(FullPageHtmlGenerator.toPrintWriter(out));
    }

    public FullPageHtmlGenerator(@Nonnull OutputStream out) {
        this(new PrintWriter(out));
    }

    @Nonnull
    private static PrintWriter toPrintWriter(@Nonnull Writer out) {
        return out instanceof PrintWriter ? (PrintWriter)out : new PrintWriter(out);
    }

    public void writeBegin() {
        this.out.println("<html>");
        this.out.println("<body>");
    }

    private void generateInternalCss(URL url) {
        this.out.println("<!-- " + url.getFile() + " -->");
        try (InputStream in = url.openStream();){
            IOUtils.copy((InputStream)in, (Writer)this.out, (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            throw SingularException.rethrow(e.getMessage(), e);
        }
    }

    public PrintWriter getOut() {
        return this.out;
    }

    public void writeEndAndClose() {
        if (!this.internalCSS.isEmpty()) {
            this.out.println("<style>");
            this.internalCSS.forEach(this::generateInternalCss);
            this.out.println("</style>");
        }
        this.out.println("</body></html>");
        this.close();
    }

    @Override
    public void close() {
        this.out.close();
    }

    public void addInternalCSSFromResource(@Nonnull Object reference, @Nonnull String cssFileName) {
        URL url = reference.getClass().getResource(cssFileName);
        this.internalCSS.add(url);
    }
}

