/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.lib.commons.views.format;

import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nullable;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.opensingular.lib.commons.util.Loggable;
import org.opensingular.lib.commons.views.ViewOutput;
import org.opensingular.lib.commons.views.ViewOutputFormat;

public class ViewOutputExcel
implements ViewOutput<XSSFSheet>,
Loggable {
    private final XSSFWorkbook workbook = new XSSFWorkbook();
    private final XSSFSheet sheet;

    public ViewOutputExcel(@Nullable String worksheetName) {
        this.sheet = worksheetName == null ? this.workbook.createSheet() : this.workbook.createSheet(worksheetName);
    }

    @Override
    public XSSFSheet getOutput() {
        return this.sheet;
    }

    @Override
    public ViewOutputFormat getFormat() {
        return ViewOutputFormat.EXCEL;
    }

    public void write(OutputStream os) throws IOException {
        this.workbook.write(os);
    }
}

