/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.lib.commons.views.format;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.opensingular.lib.commons.base.SingularException;
import org.opensingular.lib.commons.views.ViewOutput;
import org.opensingular.lib.commons.views.ViewOutputFormat;

public abstract class ViewOutputHtml
implements ViewOutput<Writer> {
    private String pathAttachment;
    private String urlApp_;
    private PrintWriter pOut_;
    private Map<String, Object> attributes;
    private HtmlCode htmlCode;

    @Override
    public ViewOutputFormat getFormat() {
        return ViewOutputFormat.HTML;
    }

    public void copyConfig(ViewOutputHtml vOut) {
        this.pathAttachment = vOut.pathAttachment;
        this.urlApp_ = vOut.urlApp_;
        if (vOut.attributes != null) {
            this.attributes = new HashMap<String, Object>(vOut.attributes);
        }
    }

    public abstract boolean isStaticContent();

    public void setPathAttachment(String path) {
        this.pathAttachment = path;
    }

    public String getPathAttachment() {
        return this.pathAttachment;
    }

    public void setUrlApp(String url) {
        this.urlApp_ = url;
    }

    public String getUrlApp() {
        if (this.urlApp_ == null) {
            throw new SingularException("Implementar esse c\u00f3digo");
        }
        return this.urlApp_;
    }

    public final PrintWriter getPrintWriter() {
        if (this.pOut_ == null) {
            Writer out = (Writer)this.getOutput();
            this.pOut_ = out instanceof PrintWriter ? (PrintWriter)out : new PrintWriter(out);
        }
        return this.pOut_;
    }

    public void flush() {
        try {
            ((Writer)this.getOutput()).flush();
        }
        catch (IOException e) {
            throw SingularException.rethrow("Falha ao descarregar contedo: " + e.getMessage(), e);
        }
    }

    public abstract void addImage(String var1, byte[] var2) throws IOException;

    public void setAttribute(String name, Object value) {
        if (this.attributes == null) {
            if (value == null) {
                return;
            }
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(name, value);
    }

    public <T> T getAttribute(String name) {
        return (T)(this.attributes != null ? this.attributes.get(name) : null);
    }

    public <T> T getAttribute(String name, T defaultValue) {
        T v = this.getAttribute(name);
        return v != null ? v : defaultValue;
    }

    public HtmlCode html() {
        if (this.htmlCode == null) {
            this.htmlCode = new HtmlCode();
        }
        return this.htmlCode;
    }

    public class HtmlCode {
        public HtmlCode br() {
            ViewOutputHtml.this.getPrintWriter().println("<br style='clear: both;'/>");
            return this;
        }

        public HtmlCode tag(String tag, String text) {
            return this.tag(tag, text, "");
        }

        public HtmlCode tag(String tag, String text, String attributes) {
            this.openTag(tag, attributes);
            ViewOutputHtml.this.getPrintWriter().print(StringUtils.trimToEmpty((String)text));
            return this.closeTag(tag);
        }

        public HtmlCode openTag(String tag) {
            return this.openTag(tag, "");
        }

        public HtmlCode openTag(String tag, String attributes) {
            ViewOutputHtml.this.getPrintWriter().print("<" + tag + " " + attributes + ">");
            return this;
        }

        public HtmlCode closeTag(String lastTag) {
            ViewOutputHtml.this.getPrintWriter().println("</" + lastTag + ">");
            return this;
        }

        public HtmlCode div(String text, String attributes) {
            return this.tag("div", text, attributes);
        }

        public HtmlCode div(String text) {
            return this.div(text, "");
        }

        public HtmlCode script(String script) {
            return this.tag("script", script, "type=\"text/javascript\"");
        }

        public HtmlCode span(String text, String attributes) {
            return this.tag("span", text, attributes);
        }

        public HtmlCode span(String text) {
            return this.span(text, "");
        }

        public HtmlCode internalTitleReporterSeprator(String title) {
            PrintWriter out = ViewOutputHtml.this.getPrintWriter();
            out.println("\n<hr width='100%' style='clear: both;'>");
            out.println("<b>" + title + "</b>");
            out.println("<br/>");
            return this;
        }
    }
}

