/*
 * Copyright (C) 2016 Singular Studios (a.k.a Atom Tecnologia) - www.opensingular.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.opensingular.flow.core.variable.type;

import org.opensingular.flow.core.SingularFlowException;
import org.opensingular.flow.core.variable.SingularFlowConvertingValueException;
import org.opensingular.flow.core.variable.VarDefinition;
import org.opensingular.flow.core.variable.VarInstance;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * Representa um tipo de variável da classe específica. As variáveis customizadas não são capazes de serem
 * persistidas para String por default.
 *
 * @author Daniel C. Bordin on 13/05/2017.
 */
public class VarTypeCustom extends VarTypeBase {

    public VarTypeCustom(@Nonnull Class classTypeContent) {
        super(classTypeContent);
    }

    @Override
    public String toDisplayString(Object value, VarDefinition varDefinition) {
        return value == null ? null : value.toString();
    }

    @Override
    public String toPersistenceString(VarInstance varInstance) {
        throw new SingularFlowException("This variable doesn't support persistence");
    }

    @Override
    protected Object fromPersistenceStringImpl(String persistenceValue) throws SingularFlowConvertingValueException {
        throw new SingularFlowException("This variable doesn't support persistence");
    }

    @Nullable
    @Override
    protected Object convertNotDirectCompatible(@Nonnull Object original) {
        return null;
    }
}
