/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.form.persistence.dao;

import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.opensingular.form.persistence.entity.FormCacheFieldEntity;
import org.opensingular.form.persistence.entity.FormTypeEntity;
import org.opensingular.lib.support.persistence.BaseDAO;

public class FormCacheFieldDAO
extends BaseDAO<FormCacheFieldEntity, Long> {
    public FormCacheFieldDAO() {
        super(FormCacheFieldEntity.class);
    }

    public FormCacheFieldEntity findField(String path, FormTypeEntity formType) {
        Criteria criteria = this.getSession().createCriteria(FormCacheFieldEntity.class);
        criteria.add((Criterion)Restrictions.eq((String)"path", (Object)path));
        criteria.add((Criterion)Restrictions.eq((String)"formTypeEntity.cod", (Object)formType.getCod()));
        return (FormCacheFieldEntity)((Object)criteria.uniqueResult());
    }

    public List<String> findPathsByName(List<String> paths) {
        Criteria criteria = this.getSession().createCriteria(this.entityClass);
        criteria.setProjection((Projection)Projections.projectionList().add((Projection)Projections.property((String)"path")));
        criteria.add(Restrictions.in((String)"path", paths));
        return criteria.list();
    }

    public FormCacheFieldEntity saveOrFind(FormCacheFieldEntity field) {
        FormCacheFieldEntity fieldFromDB = this.findField(field.getPath(), field.getFormTypeEntity());
        if (fieldFromDB != null) {
            return fieldFromDB;
        }
        this.save(field);
        return field;
    }

    public void deleteAllIndexedFields() {
        Query query = this.getSession().createQuery("delete FormCacheFieldEntity");
        int result = query.executeUpdate();
        this.getLogger().info("{} itens excluidos na atualiza\u00e7\u00e3o dos campos indexados", (Object)result);
    }
}

