/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.form.service;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.transaction.Transactional;
import org.opensingular.form.SIComposite;
import org.opensingular.form.SIList;
import org.opensingular.form.SInstance;
import org.opensingular.form.STypeAttachmentList;
import org.opensingular.form.persistence.dao.FormCacheFieldDAO;
import org.opensingular.form.persistence.dao.FormCacheValueDAO;
import org.opensingular.form.persistence.dao.FormVersionDAO;
import org.opensingular.form.persistence.dto.InstanceFormDTO;
import org.opensingular.form.persistence.entity.FormCacheFieldEntity;
import org.opensingular.form.persistence.entity.FormCacheValueEntity;
import org.opensingular.form.persistence.entity.FormEntity;
import org.opensingular.form.persistence.entity.FormTypeEntity;
import org.opensingular.form.persistence.entity.FormVersionEntity;
import org.opensingular.form.service.IFormFieldService;
import org.opensingular.form.type.core.attachment.SIAttachment;
import org.opensingular.lib.support.persistence.entity.BaseEntity;

@Named
@Transactional
public class FormFieldService
implements IFormFieldService {
    @Inject
    private FormCacheFieldDAO formCacheFieldDAO;
    @Inject
    private FormCacheValueDAO formCacheValueDAO;
    @Inject
    private FormVersionDAO formVersionDAO;

    @Override
    public void saveFields(SInstance instance, FormTypeEntity formType, FormVersionEntity formVersion) {
        LinkedHashMap<FormCacheFieldEntity, FormCacheValueEntity> mapFields = new LinkedHashMap<FormCacheFieldEntity, FormCacheValueEntity>();
        this.loadMapFromInstance(mapFields, instance, formVersion, null);
        this.deleteOldValues(formVersion);
        this.saveMap(mapFields);
        this.setFormVersionAsIndexed(formVersion.getCod());
    }

    private void setFormVersionAsIndexed(Long cod) {
        Optional formVersion = this.formVersionDAO.get(cod);
        formVersion.ifPresent(f -> {
            f.setIndexed(Character.valueOf('S'));
            this.formVersionDAO.save((BaseEntity)f);
        });
    }

    @Transactional(value=Transactional.TxType.REQUIRES_NEW)
    public void saveFields(List<InstanceFormDTO> instances) {
        for (InstanceFormDTO dto : instances) {
            FormEntity form = dto.getForm();
            this.saveFields(dto.getInstance(), form.getFormType(), form.getCurrentFormVersionEntity());
        }
    }

    private void deleteOldValues(FormVersionEntity formVersion) {
        this.formCacheValueDAO.deleteValuesFromVersion(formVersion.getCod());
    }

    private void loadMapFromInstance(Map<FormCacheFieldEntity, FormCacheValueEntity> mapFields, SInstance instance, FormVersionEntity formVersion, FormCacheValueEntity parent) {
        List fieldsInInstance = ((SIComposite)instance).getFields();
        for (SInstance field : fieldsInInstance) {
            if (!field.asAtrIndex().isPersistent().booleanValue() || field instanceof SIAttachment) continue;
            if (field instanceof SIList && !(field.getType() instanceof STypeAttachmentList)) {
                this.LoadMapWithItensFromList(mapFields, (SIList)field, formVersion, parent);
            }
            if (field instanceof SIComposite) {
                SIComposite compositeField = (SIComposite)field;
                FormCacheValueEntity parentFormValue = this.addItemToMap(mapFields, field, formVersion, parent);
                this.loadMapFromInstance(mapFields, (SInstance)compositeField, formVersion, parentFormValue);
            }
            if (field instanceof SIComposite || field instanceof SIList || field.getValue() == null) continue;
            this.addItemToMap(mapFields, field, formVersion, parent);
        }
    }

    private void LoadMapWithItensFromList(Map<FormCacheFieldEntity, FormCacheValueEntity> mapFields, SIList listField, FormVersionEntity formVersion, FormCacheValueEntity parent) {
        FormCacheValueEntity listFormValue = this.addItemToMap(mapFields, (SInstance)listField, formVersion, parent);
        for (Object subField : listField.getValues()) {
            if (subField instanceof SIComposite) {
                FormCacheValueEntity parentItem = this.addItemToMap(mapFields, (SInstance)subField, formVersion, parent);
                this.loadMapFromInstance(mapFields, (SInstance)subField, formVersion, parentItem);
                continue;
            }
            this.loadMapFromInstance(mapFields, (SInstance)subField, formVersion, listFormValue);
        }
    }

    private FormCacheValueEntity addItemToMap(Map<FormCacheFieldEntity, FormCacheValueEntity> mapFields, SInstance field, FormVersionEntity formVersion, FormCacheValueEntity parent) {
        FormTypeEntity formType = formVersion.getFormEntity().getFormType();
        String fieldName = field.getType().getName().replace(formType.getAbbreviation() + ".", "");
        FormCacheFieldEntity formField = new FormCacheFieldEntity(fieldName, formType);
        FormCacheValueEntity formValue = new FormCacheValueEntity(formField, formVersion, field, parent);
        mapFields.put(formField, formValue);
        return formValue;
    }

    private void saveMap(Map<FormCacheFieldEntity, FormCacheValueEntity> mapFields) {
        mapFields.forEach((field, value) -> {
            field = this.formCacheFieldDAO.saveOrFind((FormCacheFieldEntity)((Object)field));
            value.setCacheField((FormCacheFieldEntity)((Object)field));
            this.formCacheValueDAO.save((BaseEntity)value);
        });
    }
}

