/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.form.persistence.dao;

import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.opensingular.form.persistence.entity.FormEntity;
import org.opensingular.lib.support.persistence.BaseDAO;
import org.opensingular.lib.support.persistence.entity.BaseEntity;

public class FormDAO
extends BaseDAO<FormEntity, Long> {
    public FormDAO() {
        super(FormEntity.class);
    }

    public void delete(Long key) {
        this.find(key).ifPresent(formEntity -> {
            this.getSession().delete((Object)formEntity.getCurrentFormVersionEntity());
            this.getSession().delete((Object)formEntity);
        });
    }

    public void saveOrUpdate(FormEntity newEntity) {
        super.saveOrUpdate((BaseEntity)newEntity);
        this.getSession().flush();
    }

    public List<FormEntity> listByFormAbbreviation(String formAbbreviation) {
        return this.getfindByFormAbbreviation(formAbbreviation).list();
    }

    public List<FormEntity> listByFormAbbreviation(String formAbbreviation, long first, long max) {
        return this.getfindByFormAbbreviation(formAbbreviation).setFirstResult((int)first).setMaxResults((int)max).list();
    }

    public List<FormEntity> listUnIndexedForms() {
        Criteria criteria = this.getSession().createCriteria(FormEntity.class);
        criteria.setMaxResults(50);
        criteria.createAlias("currentFormVersionEntity", "formVersion");
        criteria.add((Criterion)Restrictions.eq((String)"formVersion.indexed", (Object)Character.valueOf('N')));
        return criteria.list();
    }

    private Criteria getfindByFormAbbreviation(String formAbbreviation) {
        return this.getSession().createCriteria(FormEntity.class).createAlias("formType", "formType").add((Criterion)Restrictions.eq((String)"formType.abbreviation", (Object)formAbbreviation));
    }
}

