/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.form.persistence.dto;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.opensingular.form.io.CompressionUtil;
import org.opensingular.form.io.IOUtil;
import org.opensingular.form.persistence.entity.AttachmentEntity;
import org.opensingular.form.persistence.service.AttachmentPersistenceService;
import org.opensingular.form.type.core.attachment.IAttachmentRef;
import org.opensingular.lib.commons.base.SingularUtil;
import org.opensingular.lib.commons.util.TempFileUtils;
import org.opensingular.lib.support.spring.util.ApplicationContextProvider;

public class AttachmentRef
implements IAttachmentRef {
    private final String id;
    private final Long codContent;
    private final String hashSha1;
    private final long size;
    private final String name;
    private File file;

    public AttachmentRef(AttachmentEntity attachmentEntity) {
        this(attachmentEntity.getCod().toString(), attachmentEntity.getCodContent(), attachmentEntity.getHashSha1(), attachmentEntity.getSize(), attachmentEntity.getName());
    }

    public AttachmentRef(String id, Long codContent, String hashSha1, long size, String name) {
        this.id = id;
        this.codContent = codContent;
        this.hashSha1 = hashSha1;
        this.size = size;
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public String getHashSHA1() {
        return this.hashSha1;
    }

    public long getSize() {
        return this.size;
    }

    public String getName() {
        return this.name;
    }

    public InputStream getContentAsInputStream() {
        try {
            if (this.file == null || !this.file.exists()) {
                AttachmentPersistenceService persistenceHandler = (AttachmentPersistenceService)ApplicationContextProvider.get().getBean("filePersistence", AttachmentPersistenceService.class);
                this.file = File.createTempFile(this.hashSha1, this.id);
                this.file.deleteOnExit();
                try (OutputStream fos = IOUtil.newBufferedOutputStream((File)this.file);){
                    persistenceHandler.loadAttachmentContent(this.codContent, fos);
                }
            }
            return CompressionUtil.inflateToInputStream((InputStream)new FileInputStream(this.file));
        }
        catch (Exception e) {
            if (this.file != null) {
                TempFileUtils.deleteAndFailQuietily((File)this.file, this.getClass());
                this.file = null;
            }
            throw SingularUtil.propagate((Throwable)e);
        }
    }

    public int hashCode() {
        String cod = this.getId();
        return cod == null ? super.hashCode() : cod.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AttachmentRef)) {
            return false;
        }
        AttachmentRef other = (AttachmentRef)obj;
        return this.getId() == other.getId() || this.getId() != null && this.getId().equals(other.getId());
    }
}

