/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.form.persistence.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.opensingular.form.document.SDocument;
import org.opensingular.form.persistence.dao.AttachmentContentDao;
import org.opensingular.form.persistence.dao.AttachmentDao;
import org.opensingular.form.persistence.dto.AttachmentRef;
import org.opensingular.form.persistence.entity.AttachmentContentEntity;
import org.opensingular.form.persistence.entity.AttachmentEntity;
import org.opensingular.form.type.core.attachment.AttachmentCopyContext;
import org.opensingular.form.type.core.attachment.IAttachmentPersistenceHandler;
import org.opensingular.form.type.core.attachment.IAttachmentRef;
import org.opensingular.lib.commons.base.SingularException;
import org.opensingular.lib.commons.base.SingularUtil;

@Transactional
public class AttachmentPersistenceService<T extends AttachmentEntity, C extends AttachmentContentEntity>
implements IAttachmentPersistenceHandler<AttachmentRef> {
    @Inject
    protected AttachmentDao<T, C> attachmentDao;
    @Inject
    protected AttachmentContentDao<C> attachmentContentDao;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AttachmentRef addAttachment(File file, long length, String name, String hashSha1) {
        try (FileInputStream fs = new FileInputStream(file);){
            T attachment = this.attachmentDao.insert(fs, length, name, hashSha1);
            AttachmentRef attachmentRef = this.createRef(attachment);
            return attachmentRef;
        }
        catch (IOException e) {
            throw SingularException.rethrow((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AttachmentCopyContext<AttachmentRef> copy(IAttachmentRef attachmentRef, SDocument document) {
        try (InputStream is = attachmentRef.getContentAsInputStream();){
            T file = this.attachmentDao.insert(is, attachmentRef.getSize(), attachmentRef.getName(), attachmentRef.getHashSHA1());
            AttachmentCopyContext attachmentCopyContext = new AttachmentCopyContext((IAttachmentRef)this.createRef(file));
            return attachmentCopyContext;
        }
        catch (IOException e) {
            throw SingularUtil.propagate((Throwable)e);
        }
    }

    public List<AttachmentRef> getAttachments() {
        return this.attachmentDao.list().stream().map(this::createRef).collect(Collectors.toList());
    }

    public AttachmentRef getAttachment(String fileId) {
        if (StringUtils.isNumeric((CharSequence)fileId)) {
            return new AttachmentRef((AttachmentEntity)this.attachmentDao.findOrException(Long.valueOf(fileId)));
        }
        return null;
    }

    public void deleteAttachment(String id, SDocument document) {
        this.attachmentDao.delete(Long.valueOf(id));
    }

    public void deleteAttachmentAndContent(AttachmentEntity attachment) {
        this.attachmentDao.delete(attachment.getCod());
    }

    public AttachmentRef createRef(T attachmentEntity) {
        return new AttachmentRef((AttachmentEntity)((Object)attachmentEntity));
    }

    @Nonnull
    public T getAttachmentEntity(@Nonnull IAttachmentRef ref) {
        return this.getAttachmentEntity(ref.getId());
    }

    @Nonnull
    public T getAttachmentEntity(@Nonnull String id) {
        return (T)((Object)((AttachmentEntity)this.attachmentDao.findOrException(Long.valueOf(id))));
    }

    public void loadAttachmentContent(Long codContent, OutputStream fos) {
        Optional content = this.attachmentContentDao.find(codContent);
        if (!content.isPresent()) {
            throw SingularException.rethrow((String)("Attachment Content not found id=" + codContent));
        }
        try (InputStream in = ((AttachmentContentEntity)((Object)content.get())).getContent().getBinaryStream();){
            IOUtils.copy((InputStream)in, (OutputStream)fos);
        }
        catch (IOException | SQLException e) {
            throw SingularException.rethrow((String)"couldn't copy content to outputstream", (Throwable)e);
        }
    }

    public List<AttachmentEntity> listOldOrphanAttachments() {
        return this.attachmentDao.listOldOrphanAttachments();
    }
}

