/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.form.persistence.service;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.transaction.Transactional;
import net.vidageek.mirror.dsl.Mirror;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.opensingular.form.SInstance;
import org.opensingular.form.SType;
import org.opensingular.form.document.RefType;
import org.opensingular.form.document.SDocumentFactory;
import org.opensingular.form.persistence.FormKey;
import org.opensingular.form.persistence.FormRespository;
import org.opensingular.form.persistence.exception.HibernateFormRepositoryException;
import org.opensingular.form.persistence.service.HibernateFormKey;
import org.opensingular.lib.support.persistence.entity.BaseEntity;

@Transactional
public abstract class HibernateFormRepository<T extends BaseEntity, ID extends Serializable, TYPE extends SType<INSTANCE>, INSTANCE extends SInstance>
implements FormRespository<TYPE, INSTANCE> {
    protected Class<T> entityClass;
    protected Class<TYPE> sTypeClass;
    protected Class<ID> idClass;
    @Inject
    private SDocumentFactory sDocumentFactory;
    @Inject
    private SessionFactory sessionFactory;

    public HibernateFormRepository(Class<T> entityClass, Class<TYPE> sTypeClass, Class<ID> idClass) {
        this.entityClass = entityClass;
        this.sTypeClass = sTypeClass;
        this.idClass = idClass;
    }

    protected Session getSession() {
        return this.sessionFactory.getCurrentSession();
    }

    @Nonnull
    public FormKey keyFromObject(@Nonnull Object objectValueToBeConverted) {
        if (objectValueToBeConverted instanceof BaseEntity) {
            return this.formKeyfromEntityCod(((BaseEntity)objectValueToBeConverted).getCod());
        }
        return this.formKeyfromEntityCod((Serializable)objectValueToBeConverted);
    }

    public FormKey formKeyfromEntityCod(@Nonnull ID entityCod) {
        return new HibernateFormKey<ID>(entityCod);
    }

    public ID entityCodFromFormKey(@Nonnull FormKey formKey) {
        if (formKey instanceof HibernateFormKey) {
            return ((HibernateFormKey)formKey).getEntityCod();
        }
        throw new HibernateFormRepositoryException("A FormKey informada n\u00e3o \u00e9 do tipo HibernateFormKey");
    }

    @Nonnull
    public FormKey insert(@Nonnull INSTANCE instance, Integer inclusionActor) {
        T entity = this.toEntity(instance, null);
        this.getSession().save(entity);
        FormKey formKey = this.keyFromObject(entity);
        FormKey.setOnInstance(instance, (FormKey)formKey);
        return formKey;
    }

    public void delete(@Nonnull FormKey key) {
        this.getSession().delete(this.getSession().get(this.entityClass, this.entityCodFromFormKey(key)));
    }

    public void update(@Nonnull INSTANCE instance, Integer inclusionActor) {
        T entity = this.toEntity(instance, this.entityCodFromFormKey(FormKey.fromInstance(instance)));
        this.getSession().update(entity);
    }

    @Nonnull
    public FormKey insertOrUpdate(@Nonnull INSTANCE instance, Integer inclusionActor) {
        T entity = this.toEntity(instance, FormKey.fromInstanceOpt(instance).map(this::entityCodFromFormKey).orElse(null));
        this.getSession().saveOrUpdate(entity);
        FormKey.setOnInstance(instance, (FormKey)this.keyFromObject(entity));
        return FormKey.from(instance);
    }

    public boolean isPersistent(@Nonnull INSTANCE instance) {
        return FormKey.fromInstanceOpt(instance).isPresent();
    }

    @Nonnull
    public FormKey newVersion(@Nonnull INSTANCE instance, Integer inclusionActor, boolean keepAnnotations) {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    public INSTANCE load(@Nonnull FormKey key) {
        return (INSTANCE)Optional.ofNullable((BaseEntity)this.getSession().get(this.entityClass, this.entityCodFromFormKey(key))).map(this::toSinstanceSettingFormKey).orElseThrow(RuntimeException::new);
    }

    @Nonnull
    public Optional<INSTANCE> loadOpt(@Nonnull FormKey key) {
        return Optional.ofNullable((BaseEntity)this.getSession().get(this.entityClass, this.entityCodFromFormKey(key))).map(this::toSinstanceSettingFormKey);
    }

    @Nonnull
    public List<INSTANCE> loadAll(long first, long max) {
        return this.getSession().createCriteria(this.entityClass).setFirstResult((int)first).setMaxResults((int)max).list().stream().map(i -> this.toSinstanceSettingFormKey((BaseEntity)i)).collect(Collectors.toList());
    }

    @Nonnull
    public List<INSTANCE> loadAll() {
        return this.getSession().createCriteria(this.entityClass).list().stream().map(i -> this.toSinstanceSettingFormKey((BaseEntity)i)).collect(Collectors.toList());
    }

    public long countAll() {
        return (Long)this.getSession().createQuery(" select count(*) from " + this.entityClass.getName()).uniqueResult();
    }

    public INSTANCE createInstance() {
        return (INSTANCE)this.sDocumentFactory.createInstance(RefType.of(this.sTypeClass));
    }

    public INSTANCE toSinstanceSettingFormKey(T entity) {
        INSTANCE instance = this.toSinstance(entity);
        FormKey.setOnInstance(instance, (FormKey)this.keyFromObject(entity));
        return instance;
    }

    private INSTANCE toSinstance(T entity) {
        INSTANCE instance = this.createInstance();
        this.fillSInstance(instance, entity);
        return instance;
    }

    private T toEntity(INSTANCE instance, ID key) {
        BaseEntity entity;
        if (key == null) {
            try {
                entity = (BaseEntity)new Mirror().on(this.entityClass).reflect().constructor().withoutArgs().newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new HibernateFormRepositoryException(e);
            }
        } else {
            entity = (BaseEntity)this.getSession().load(this.entityClass, key);
        }
        this.fillEntity(instance, entity);
        return (T)entity;
    }

    public ID entityCodFromInstance(INSTANCE sinstance) {
        return (ID)((Serializable)FormKey.fromInstanceOpt(sinstance).map(this::entityCodFromFormKey).orElse(null));
    }

    public abstract void fillEntity(INSTANCE var1, T var2);

    public abstract void fillSInstance(INSTANCE var1, T var2);

    public T load(ID id) {
        return (T)((BaseEntity)this.getSession().load(this.entityClass, id));
    }

    public T get(ID id) {
        return (T)((BaseEntity)this.getSession().get(this.entityClass, id));
    }
}

