/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.form.persistence.service;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.transaction.Transactional;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;
import org.hibernate.SessionFactory;
import org.opensingular.form.persistence.RelationalDatabase;
import org.opensingular.form.persistence.relational.RelationalTupleHandler;
import org.opensingular.form.type.core.attachment.IAttachmentRef;
import org.opensingular.lib.commons.base.SingularException;
import org.opensingular.lib.commons.util.Loggable;

@Transactional
public class RelationalDatabaseHibernate
implements RelationalDatabase,
Loggable {
    private SessionFactory sessionFactory;

    public RelationalDatabaseHibernate(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public int exec(String sql) {
        this.getLogger().debug(sql);
        return (Integer)this.sessionFactory.getCurrentSession().doReturningWork(connection -> connection.createStatement().executeUpdate(sql));
    }

    public int exec(String sql, List<Object> params) {
        this.getLogger().debug(sql);
        return (Integer)this.sessionFactory.getCurrentSession().doReturningWork(connection -> this.prepareStatement(connection, sql, params, null, null).executeUpdate());
    }

    public int execReturningGenerated(String sql, List<Object> params, List<String> generatedColumns, RelationalTupleHandler<?> tupleHandler) {
        if (generatedColumns.isEmpty()) {
            return this.exec(sql, params);
        }
        return (Integer)this.sessionFactory.getCurrentSession().doReturningWork(connection -> {
            String newSQL = sql;
            for (Object param : params) {
                newSQL = newSQL.replaceFirst("\\?", this.toSqlConstant(param));
            }
            this.getLogger().debug(newSQL);
            Statement statement = connection.createStatement();
            int result = statement.executeUpdate(newSQL, generatedColumns.toArray(new String[generatedColumns.size()]));
            try (ResultSet rs = statement.getGeneratedKeys();){
                while (rs.next()) {
                    tupleHandler.tuple(rs);
                }
            }
            return result;
        });
    }

    public List<Object[]> query(String sql, List<Object> params) {
        return this.query(sql, params, null, null);
    }

    public <T> List<T> query(String sql, List<Object> params, RelationalTupleHandler<T> tupleHandler) {
        return this.query(sql, params, null, null, tupleHandler);
    }

    public List<Object[]> query(String sql, List<Object> params, Long limitOffset, Long limitRows) {
        return this.query(sql, params, limitOffset, limitRows, rs -> {
            Object[] tuple = new Object[rs.getMetaData().getColumnCount()];
            for (int i = 0; i < tuple.length; ++i) {
                tuple[i] = rs.getObject(i + 1);
            }
            return tuple;
        });
    }

    public <T> List<T> query(String sql, List<Object> params, Long limitOffset, Long limitRows, RelationalTupleHandler<T> tupleHandler) {
        this.getLogger().debug(sql);
        return (List)this.sessionFactory.getCurrentSession().doReturningWork(connection -> {
            ArrayList<Object> result = new ArrayList<Object>();
            try (ResultSet rs = this.prepareStatement(connection, sql, params, limitOffset, limitRows).executeQuery();){
                long rowMin = Optional.ofNullable(limitOffset).orElse(0L);
                long rowMax = rowMin - 1L + Optional.ofNullable(limitRows).orElse(Long.MAX_VALUE - rowMin);
                for (long row = 0L; rs.next() && row <= rowMax; ++row) {
                    if (row < rowMin) continue;
                    result.add(tupleHandler.tuple(rs));
                }
            }
            return result;
        });
    }

    private PreparedStatement prepareStatement(Connection connection, String sql, List<Object> params, Long limitOffset, Long limitRows) throws SQLException {
        PreparedStatement statement = connection.prepareStatement(sql);
        for (int i = 0; i < params.size(); ++i) {
            statement.setObject(i + 1, this.targetParam(params.get(i), connection));
        }
        return statement;
    }

    private Object targetParam(Object sourceParam, Connection connection) {
        Object result = sourceParam;
        if (sourceParam instanceof IAttachmentRef) {
            result = this.toBLOB((IAttachmentRef)sourceParam, connection);
        }
        return result;
    }

    private Object toBLOB(IAttachmentRef attachmentRef, Connection connection) {
        try {
            Blob blob = connection.createBlob();
            try (OutputStream output = blob.setBinaryStream(1L);
                 InputStream input = attachmentRef.getContentAsInputStream();){
                org.apache.pdfbox.io.IOUtils.copy((InputStream)input, (OutputStream)output);
            }
            return blob;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private String toSqlConstant(Object parameterValue) {
        if (parameterValue == null) {
            return "NULL";
        }
        if (parameterValue instanceof Character) {
            return this.toSqlConstant(String.valueOf(parameterValue));
        }
        if (parameterValue instanceof String) {
            return "'" + ((String)parameterValue).replace("'", "''") + "'";
        }
        if (parameterValue instanceof IAttachmentRef) {
            try {
                return "X'" + Hex.encodeHexString((byte[])IOUtils.toByteArray((InputStream)((IAttachmentRef)parameterValue).getContentAsInputStream())) + "'";
            }
            catch (IOException e) {
                throw SingularException.rethrow((Throwable)e);
            }
        }
        return parameterValue.toString();
    }
}

