/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.form.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.transaction.Transactional;
import org.opensingular.form.SInfoType;
import org.opensingular.form.SInstance;
import org.opensingular.form.document.RefType;
import org.opensingular.form.document.SDocumentFactory;
import org.opensingular.form.io.SFormXMLUtil;
import org.opensingular.form.persistence.dao.FormCacheFieldDAO;
import org.opensingular.form.persistence.dao.FormCacheValueDAO;
import org.opensingular.form.persistence.dao.FormDAO;
import org.opensingular.form.persistence.dao.FormVersionDAO;
import org.opensingular.form.persistence.dto.InstanceFormDTO;
import org.opensingular.form.persistence.entity.FormEntity;
import org.opensingular.form.service.FormFieldService;
import org.opensingular.lib.commons.scan.SingularClassPathScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Transactional
@Named
public class FormIndexService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormIndexService.class);
    @Inject
    private FormFieldService formFieldService;
    @Inject
    private FormDAO formDAO;
    @Inject
    private FormVersionDAO formVersionDAO;
    @Inject
    private FormCacheFieldDAO formFieldDAO;
    @Inject
    private FormCacheValueDAO formCacheValueDAO;

    public void indexAllForms() {
        LOGGER.info("Iniciando a indexa\u00e7\u00e3o total da base");
        long startNanos = System.nanoTime();
        boolean hasMoreItens = true;
        ArrayList<InstanceFormDTO> instancesToIndex = new ArrayList<InstanceFormDTO>();
        SingularClassPathScanner scanner = SingularClassPathScanner.get();
        Set classesFromClassloader = scanner.findClassesAnnotatedWith(SInfoType.class);
        classesFromClassloader.removeAll(classesFromClassloader.stream().filter(c -> c.getName().contains("org.opensingular")).collect(Collectors.toList()));
        while (hasMoreItens) {
            List<FormEntity> forms = this.formDAO.listUnIndexedForms();
            if (forms.isEmpty()) {
                hasMoreItens = false;
                continue;
            }
            for (FormEntity form : forms) {
                String formType = form.getFormType().getAbbreviation();
                String typeName = formType.substring(formType.lastIndexOf(46) + 1, formType.length());
                Optional<Class> clazz = classesFromClassloader.stream().filter(c -> c.getName().contains(typeName)).findFirst();
                if (clazz.isPresent()) {
                    Class formClass = clazz.get();
                    RefType refType = RefType.of((Class)formClass);
                    SDocumentFactory sDocumentFactory = SDocumentFactory.empty();
                    SInstance instance = SFormXMLUtil.fromXML((RefType)refType, (String)form.getCurrentFormVersionEntity().getXml(), (SDocumentFactory)sDocumentFactory);
                    InstanceFormDTO dto = new InstanceFormDTO();
                    dto.setInstance(instance);
                    dto.setForm(form);
                    instancesToIndex.add(dto);
                    continue;
                }
                LOGGER.info("N\u00e3o foi poss\u00edvel indexar o form {}", (Object)formType);
            }
            this.formFieldService.saveFields(instancesToIndex);
            instancesToIndex = new ArrayList();
        }
        long duration = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
        LOGGER.info("Indexa\u00e7\u00e3o completa. Dura\u00e7\u00e3o: {} millis", (Object)duration);
    }

    public void resetIndexedFlag() {
        this.formVersionDAO.resetIndexedFlag();
        this.formCacheValueDAO.deleteAllIndexedData();
        this.formFieldDAO.deleteAllIndexedFields();
    }
}

