/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.form.service;

import java.util.List;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.opensingular.form.SFormUtil;
import org.opensingular.form.SType;
import org.opensingular.form.persistence.dao.FormTypeDAO;
import org.opensingular.form.persistence.entity.FormTypeEntity;

@Transactional
public class FormTypeService {
    @Inject
    private FormTypeDAO formTypeDAO;

    public FormTypeEntity findFormTypeEntity(SType<?> type) {
        return this.getOrCreateNewFormTypeEntity(type);
    }

    private FormTypeEntity getOrCreateNewFormTypeEntity(SType<?> type) {
        String name = type.getName();
        FormTypeEntity formTypeEntity = this.formTypeDAO.findFormTypeByAbbreviation(name);
        if (formTypeEntity == null) {
            formTypeEntity = new FormTypeEntity();
            formTypeEntity.setAbbreviation(name);
            formTypeEntity.setLabel(SFormUtil.getTypeLabel(type.getClass()).orElse(type.getNameSimple()));
            formTypeEntity.setCacheVersionNumber(1L);
            this.formTypeDAO.saveOrUpdate(formTypeEntity);
        }
        return formTypeEntity;
    }

    public List<FormTypeEntity> listAll() {
        return this.formTypeDAO.listAll();
    }

    public FormTypeEntity findFormTypeByAbbreviation(String abbreviation) {
        return this.formTypeDAO.findFormTypeByAbbreviation(abbreviation);
    }
}

