/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.form.persistence.dao;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.function.Consumer;
import java.util.zip.Deflater;
import java.util.zip.DeflaterInputStream;
import javax.annotation.Nonnull;
import javax.transaction.Transactional;
import org.apache.commons.io.IOUtils;
import org.opensingular.form.persistence.entity.AttachmentContentEntity;
import org.opensingular.lib.commons.base.SingularException;
import org.opensingular.lib.commons.io.TempFileInputStream;
import org.opensingular.lib.support.persistence.BaseDAO;

@Transactional(value=Transactional.TxType.MANDATORY)
public class AttachmentContentDao<T extends AttachmentContentEntity>
extends BaseDAO<T, Long> {
    public AttachmentContentDao() {
        super(AttachmentContentEntity.class);
    }

    protected AttachmentContentDao(Class<T> entityClass) {
        super(entityClass);
    }

    public T insert(T o) {
        this.getSession().save(o);
        return o;
    }

    public T insert(InputStream is, long length, String hashSha1) {
        if (hashSha1 == null) {
            throw SingularException.rethrow((String)"Essa persistencia de arquivo n\u00e3o suporta o c\u00e1lculo de hash, favor fornecer o hash calculado.");
        }
        return (T)((Object)this.createContentAndAcceptConsumer(is, length, hashSha1, this::insert));
    }

    public void delete(@Nonnull Long codContent) {
        this.find(codContent).ifPresent(arg_0 -> ((AttachmentContentDao)this).delete(arg_0));
    }

    protected T createContentAndAcceptConsumer(InputStream in, long length, String hashSha1, Consumer<T> consummerEntity) {
        try {
            File file = File.createTempFile(((Object)((Object)this)).getClass().getName(), hashSha1);
            DeflaterInputStream inZip = new DeflaterInputStream(in, new Deflater(9));
            try (FileOutputStream fos = new FileOutputStream(file);){
                IOUtils.copy((InputStream)inZip, (OutputStream)fos);
            }
            T fileEntity = this.createInstance();
            ((AttachmentContentEntity)((Object)fileEntity)).setContent(this.getSession().getLobHelper().createBlob((InputStream)new TempFileInputStream(file), file.length()));
            ((AttachmentContentEntity)((Object)fileEntity)).setHashSha1(hashSha1);
            ((AttachmentContentEntity)((Object)fileEntity)).setSize(length);
            ((AttachmentContentEntity)((Object)fileEntity)).setInclusionDate(new Date());
            consummerEntity.accept(fileEntity);
            return fileEntity;
        }
        catch (Exception e) {
            throw SingularException.rethrow((String)e.getMessage(), (Throwable)e);
        }
    }

    protected T createInstance() {
        try {
            return (T)((Object)((AttachmentContentEntity)((Object)this.entityClass.newInstance())));
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw SingularException.rethrow((Throwable)e);
        }
    }
}

