/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.form.persistence.dao;

import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.joda.time.DateTime;
import org.opensingular.form.persistence.dao.AttachmentContentDao;
import org.opensingular.form.persistence.entity.AbstractFormAttachmentEntity;
import org.opensingular.form.persistence.entity.AttachmentContentEntity;
import org.opensingular.form.persistence.entity.AttachmentEntity;
import org.opensingular.lib.commons.base.SingularException;
import org.opensingular.lib.support.persistence.BaseDAO;

@Transactional(value=Transactional.TxType.MANDATORY)
public class AttachmentDao<T extends AttachmentEntity, C extends AttachmentContentEntity>
extends BaseDAO<T, Long> {
    @Inject
    private AttachmentContentDao<C> attachmentContentDao;

    public AttachmentDao() {
        super(AttachmentEntity.class);
    }

    public AttachmentDao(Class<T> entityClass) {
        super(entityClass);
    }

    public T insert(T o) {
        this.getSession().save(o);
        return o;
    }

    public T insert(InputStream is, long length, String name, String hashSha1) {
        C content = this.attachmentContentDao.insert(is, length, hashSha1);
        return this.insert(this.createAttachment(content, name));
    }

    public void delete(Long id) {
        Optional t = this.get(id);
        if (t.isPresent()) {
            AttachmentEntity entity = (AttachmentEntity)((Object)t.get());
            Long codContent = entity.getCodContent();
            this.delete(entity);
            this.attachmentContentDao.delete(codContent);
        }
    }

    public List<T> list() {
        Criteria crit = this.getSession().createCriteria(this.entityClass);
        return crit.list();
    }

    protected T createAttachment(C content, String name) {
        T fileEntity = this.createInstance();
        ((AttachmentEntity)((Object)fileEntity)).setCodContent(((AttachmentContentEntity)((Object)content)).getCod());
        ((AttachmentEntity)((Object)fileEntity)).setHashSha1(((AttachmentContentEntity)((Object)content)).getHashSha1());
        ((AttachmentEntity)((Object)fileEntity)).setSize(((AttachmentContentEntity)((Object)content)).getSize());
        ((AttachmentEntity)((Object)fileEntity)).setCreationDate(new Date());
        ((AttachmentEntity)((Object)fileEntity)).setName(this.truncateNameIfNeeded(name));
        return fileEntity;
    }

    private String truncateNameIfNeeded(String s) {
        if (s != null && s.length() > 200) {
            String extension = "";
            int lastIndexOfDot = s.lastIndexOf(46);
            if (lastIndexOfDot > 0) {
                extension = s.substring(lastIndexOfDot, s.length());
            }
            String name = s.substring(0, 200 - extension.length());
            return (name + extension).substring(0, 200);
        }
        return s;
    }

    protected T createInstance() {
        try {
            return (T)((Object)((AttachmentEntity)((Object)this.entityClass.newInstance())));
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw SingularException.rethrow((Throwable)e);
        }
    }

    public List<AttachmentEntity> listOldOrphanAttachments() {
        StringBuilder hql = new StringBuilder();
        hql.append(" SELECT a FROM ").append(AttachmentEntity.class.getName()).append(" as a ");
        hql.append(" WHERE a.creationDate < :ontem ");
        hql.append(" AND NOT EXISTS ( ");
        hql.append("    SELECT 1 FROM ").append(AbstractFormAttachmentEntity.class.getName()).append(" as fa ");
        hql.append("    WHERE fa.cod.attachmentCod = a.cod ");
        hql.append(" ) ");
        Query query = this.getSession().createQuery(hql.toString());
        Date ontem = new DateTime().minusDays(1).toDate();
        query.setParameter("ontem", (Object)ontem);
        return query.list();
    }

    public Optional<T> find(Long aLong) {
        Optional t = super.find((Serializable)aLong);
        if (t.isPresent()) {
            Hibernate.initialize((Object)t);
        }
        return t;
    }
}

