/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.form.persistence.dao;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.hibernate.SQLQuery;
import org.hibernate.SessionFactory;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.opensingular.form.persistence.dao.IndexedDataQueryBuilder;
import org.opensingular.form.persistence.dto.BaseDTO;
import org.opensingular.form.persistence.dto.STypeIndexed;
import org.springframework.stereotype.Repository;

@Repository
@Transactional(value=Transactional.TxType.NEVER)
public class IndexedDataDAO {
    @Inject
    protected SessionFactory sessionFactory;

    protected String createSqlFromDTO(Class<? extends BaseDTO> dto, String schema) {
        IndexedDataQueryBuilder builder = new IndexedDataQueryBuilder(schema);
        for (Field field : dto.getDeclaredFields()) {
            if (!field.getAnnotation(STypeIndexed.class).indexedColumn()) continue;
            builder.addColumn(field.getName(), field.getAnnotation(STypeIndexed.class).path());
        }
        return builder.createQueryForIndexedData();
    }

    protected void addScalarsFromDTO(SQLQuery query, Class<? extends BaseDTO> dto) {
        for (Field field : dto.getDeclaredFields()) {
            if (!field.getAnnotation(STypeIndexed.class).returnColumn()) continue;
            if (BigDecimal.class.isAssignableFrom(field.getType())) {
                query.addScalar(field.getName(), (Type)StandardBasicTypes.BIG_DECIMAL);
                continue;
            }
            query.addScalar(field.getName());
        }
    }
}

