/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.form.persistence.service;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.transaction.Transactional;
import org.opensingular.form.SFormUtil;
import org.opensingular.form.SIComposite;
import org.opensingular.form.SInstance;
import org.opensingular.form.SType;
import org.opensingular.form.document.RefType;
import org.opensingular.form.document.SDocumentFactory;
import org.opensingular.form.persistence.AbstractFormPersistence;
import org.opensingular.form.persistence.FormKey;
import org.opensingular.form.persistence.FormKeyLong;
import org.opensingular.form.persistence.dao.FormDAO;
import org.opensingular.form.persistence.entity.FormEntity;
import org.opensingular.form.service.IFormService;

@Transactional
public class FormServiceFormPersistence<TYPE extends SType<INSTANCE>, INSTANCE extends SIComposite>
extends AbstractFormPersistence<TYPE, INSTANCE, FormKeyLong> {
    private IFormService formService;
    private SDocumentFactory documentFactory;
    private Class<TYPE> typeClass;
    private FormDAO formDAO;

    public FormServiceFormPersistence() {
        super(FormKeyLong.class);
    }

    public long countAll() {
        return this.loadAllInternal().size();
    }

    protected INSTANCE loadInternal(FormKeyLong key) {
        return (INSTANCE)((SIComposite)this.formService.loadSInstance((FormKey)key, this.getRefType(), this.documentFactory));
    }

    @Nonnull
    private RefType getRefType() {
        return RefType.of(this.typeClass);
    }

    @Nonnull
    protected List<INSTANCE> loadAllInternal() {
        return this.formDAO.listByFormAbbreviation(SFormUtil.getTypeName(this.typeClass)).stream().map(FormEntity::getCod).map(FormKeyLong::convertToKey).map(this::load).collect(Collectors.toList());
    }

    @Nonnull
    protected List<INSTANCE> loadAllInternal(long first, long max) {
        return this.formDAO.listByFormAbbreviation(SFormUtil.getTypeName(this.typeClass), first, max).stream().map(FormEntity::getCod).map(FormKeyLong::convertToKey).map(this::load).collect(Collectors.toList());
    }

    @Nonnull
    public FormKey newVersion(@Nonnull INSTANCE instance, Integer inclusionActor, boolean keepAnnotations) {
        return this.formService.newVersion((SInstance)instance, inclusionActor, keepAnnotations);
    }

    protected void updateInternal(@Nonnull FormKeyLong key, @Nonnull INSTANCE instance, Integer inclusionActor) {
        instance.getDocument().persistFiles();
        this.formService.update((SInstance)instance, inclusionActor);
    }

    protected void deleteInternal(@Nonnull FormKeyLong key) {
        this.formDAO.delete(key.longValue());
    }

    @Nonnull
    protected FormKeyLong insertInternal(@Nonnull INSTANCE instance, Integer inclusionActor) {
        instance.getDocument().persistFiles();
        return (FormKeyLong)this.formService.insert((SInstance)instance, inclusionActor);
    }

    public INSTANCE createInstance() {
        return (INSTANCE)((SIComposite)this.documentFactory.createInstance(this.getRefType()));
    }

    public void update(@Nonnull INSTANCE instance, Integer inclusionActor) {
        super.update(instance, inclusionActor);
    }

    @Nonnull
    public List<INSTANCE> loadAll() {
        return super.loadAll();
    }

    @Nonnull
    public List<INSTANCE> loadAll(long first, long max) {
        return super.loadAll(first, max);
    }

    @Nonnull
    public INSTANCE load(@Nonnull FormKey key) {
        return (INSTANCE)((SIComposite)super.load(key));
    }

    @Nonnull
    public FormKey insert(@Nonnull INSTANCE instance, Integer inclusionActor) {
        return super.insert(instance, inclusionActor);
    }

    @Nonnull
    public FormKey insertOrUpdate(@Nonnull INSTANCE instance, Integer inclusionActor) {
        return super.insertOrUpdate(instance, inclusionActor);
    }

    @Nonnull
    public Optional<INSTANCE> loadOpt(@Nonnull FormKey key) {
        return super.loadOpt(key);
    }

    public void delete(@Nonnull FormKey key) {
        super.delete(key);
    }

    public IFormService getFormService() {
        return this.formService;
    }

    public void setFormService(IFormService formService) {
        this.formService = formService;
    }

    public SDocumentFactory getDocumentFactory() {
        return this.documentFactory;
    }

    public void setDocumentFactory(SDocumentFactory documentFactory) {
        this.documentFactory = documentFactory;
    }

    public Class<TYPE> getTypeClass() {
        return this.typeClass;
    }

    public void setTypeClass(Class<TYPE> typeClass) {
        this.typeClass = typeClass;
    }

    public FormDAO getFormDAO() {
        return this.formDAO;
    }

    public void setFormDAO(FormDAO formDAO) {
        this.formDAO = formDAO;
    }
}

