/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.form.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.apache.commons.lang3.NotImplementedException;
import org.opensingular.form.SInstance;
import org.opensingular.form.document.RefType;
import org.opensingular.form.document.SDocument;
import org.opensingular.form.document.SDocumentFactory;
import org.opensingular.form.io.SFormXMLUtil;
import org.opensingular.form.persistence.AnnotationKey;
import org.opensingular.form.persistence.FormKey;
import org.opensingular.form.persistence.FormKeyLong;
import org.opensingular.form.persistence.FormKeyManager;
import org.opensingular.form.persistence.SingularFormPersistenceException;
import org.opensingular.form.persistence.dao.FormAnnotationDAO;
import org.opensingular.form.persistence.dao.FormAnnotationVersionDAO;
import org.opensingular.form.persistence.dao.FormDAO;
import org.opensingular.form.persistence.dao.FormVersionDAO;
import org.opensingular.form.persistence.entity.FormAnnotationEntity;
import org.opensingular.form.persistence.entity.FormAnnotationPK;
import org.opensingular.form.persistence.entity.FormAnnotationVersionEntity;
import org.opensingular.form.persistence.entity.FormEntity;
import org.opensingular.form.persistence.entity.FormVersionEntity;
import org.opensingular.form.service.FormTypeService;
import org.opensingular.form.service.IFormService;
import org.opensingular.form.type.basic.SPackageBasic;
import org.opensingular.form.type.core.annotation.DocumentAnnotations;
import org.opensingular.form.type.core.annotation.SIAnnotation;
import org.opensingular.lib.commons.lambda.IConsumer;

@Transactional
public class FormService
implements IFormService {
    private static final boolean KEEP_ANNOTATIONS = true;
    private final FormKeyManager<? extends FormKey> formKeyManager = new FormKeyManager(FormKeyLong.class, e -> this.addInfo((SingularFormPersistenceException)e));
    @Inject
    private FormDAO formDAO;
    @Inject
    private FormVersionDAO formVersionDAO;
    @Inject
    private FormAnnotationDAO formAnnotationDAO;
    @Inject
    private FormAnnotationVersionDAO formAnnotationVersionDAO;
    @Inject
    private FormTypeService formTypeService;

    @Nonnull
    private final FormKeyManager<FormKey> getFormKeyManager() {
        return this.formKeyManager;
    }

    @Override
    @Nonnull
    public FormKey keyFromObject(@Nonnull Object objectValueToBeConverted) {
        return this.formKeyManager.keyFromObject(objectValueToBeConverted);
    }

    @Override
    public void update(@Nonnull SInstance instance, Integer inclusionActor) {
        FormKey key = this.getFormKeyManager().readFormKeyOrException(instance);
        this.updateInternal(this.loadFormEntity(key), instance, inclusionActor);
    }

    @Override
    @Nonnull
    public FormKey insertOrUpdate(@Nonnull SInstance instance, Integer inclusionActor) {
        FormKey updatedKey;
        Optional key = this.getFormKeyManager().readFormKeyOptional(instance);
        if (key.isPresent()) {
            this.updateInternal(this.loadFormEntity((FormKey)key.get()), instance, inclusionActor);
            updatedKey = (FormKey)key.get();
        } else {
            updatedKey = this.insertImpl(instance, inclusionActor);
        }
        return updatedKey;
    }

    @Override
    @Nonnull
    public FormKey insert(@Nonnull SInstance instance, Integer inclusionActor) {
        return this.insertImpl(instance, inclusionActor);
    }

    @Nonnull
    private FormKey insertImpl(@Nonnull SInstance instance, Integer inclusionActor) {
        FormKeyLong key = this.insertInternal(instance, inclusionActor);
        this.getFormKeyManager().validKeyOrException((FormKey)key, instance, "Era esperado que o insert interno gerasse uma FormKey, mas retornou null");
        FormKey.set((SInstance)instance, (FormKey)key);
        return key;
    }

    @Override
    public final boolean isPersistent(@Nonnull SInstance instance) {
        return this.getFormKeyManager().isPersistent(instance);
    }

    @Nonnull
    private SingularFormPersistenceException addInfo(@Nonnull SingularFormPersistenceException exception) {
        exception.add("persitence", (Object)this.toString());
        return exception;
    }

    @Nonnull
    private SInstance internalLoadSInstance(@Nonnull FormKey key, @Nonnull RefType refType, @Nonnull SDocumentFactory documentFactory, @Nonnull FormVersionEntity formVersionEntity) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(refType);
        Objects.requireNonNull(documentFactory);
        Objects.requireNonNull(formVersionEntity);
        SInstance instance = SFormXMLUtil.fromXML((RefType)refType, (String)formVersionEntity.getXml(), (SDocumentFactory)documentFactory);
        IConsumer loadListener = (IConsumer)instance.getAttributeValue(SPackageBasic.ATR_LOAD_LISTENER);
        this.loadCurrentXmlAnnotationOrEmpty(instance.getDocument(), formVersionEntity);
        FormKey.set((SInstance)instance, (FormKey)key);
        if (loadListener != null) {
            loadListener.accept((Object)instance);
        }
        return instance;
    }

    @Override
    @Nonnull
    public SInstance newTransientSInstance(@Nonnull FormKey key, @Nonnull RefType refType, @Nonnull SDocumentFactory documentFactory) {
        SInstance instance = this.loadSInstance(key, refType, documentFactory);
        FormKey.set((SInstance)instance, null);
        return instance;
    }

    @Override
    @Nonnull
    public SInstance newTransientSInstance(@Nonnull FormKey key, @Nonnull RefType refType, @Nonnull SDocumentFactory documentFactory, @Nonnull Long versionId) {
        SInstance instance = this.loadSInstance(key, refType, documentFactory, versionId);
        FormKey.set((SInstance)instance, null);
        return instance;
    }

    @Override
    @Nonnull
    public SInstance newTransientSInstance(@Nonnull FormKey key, @Nonnull RefType refType, @Nonnull SDocumentFactory documentFactory, boolean keepAnnotations) {
        SInstance instance = this.newTransientSInstance(key, refType, documentFactory);
        instance.getDocument().getDocumentAnnotations().clear();
        return instance;
    }

    @Override
    @Nonnull
    public SInstance newTransientSInstance(@Nonnull FormKey key, @Nonnull RefType refType, @Nonnull SDocumentFactory documentFactory, @Nonnull Long versionId, boolean keepAnnotations) {
        SInstance instance = this.newTransientSInstance(key, refType, documentFactory, versionId);
        instance.getDocument().getDocumentAnnotations().clear();
        return instance;
    }

    @Override
    @Nonnull
    public SInstance loadSInstance(@Nonnull FormKey key, @Nonnull RefType refType, @Nonnull SDocumentFactory documentFactory) {
        FormEntity entity = this.loadFormEntity(key);
        return this.internalLoadSInstance(key, refType, documentFactory, entity.getCurrentFormVersionEntity());
    }

    @Override
    @Nonnull
    public SInstance loadSInstance(@Nonnull FormKey key, @Nonnull RefType refType, @Nonnull SDocumentFactory documentFactory, @Nonnull Long versionId) {
        Objects.requireNonNull(versionId);
        FormVersionEntity formVersionEntity = this.loadFormVersionEntity(versionId);
        return this.internalLoadSInstance(key, refType, documentFactory, formVersionEntity);
    }

    private FormKeyLong insertInternal(@Nonnull SInstance instance, Integer inclusionActor) {
        FormEntity entity = this.saveNewFormEntity(instance);
        this.saveOrUpdateFormVersion(instance, entity, new FormVersionEntity(), inclusionActor, true);
        return new FormKeyLong(entity.getCod());
    }

    @Nonnull
    private FormEntity saveNewFormEntity(@Nonnull SInstance instance) {
        FormEntity entity = new FormEntity();
        entity.setFormType(this.formTypeService.findFormTypeEntity(instance.getType()));
        this.formDAO.saveOrUpdate(entity);
        return entity;
    }

    private void saveOrUpdateFormVersion(@Nonnull SInstance instance, @Nonnull FormEntity entity, @Nonnull FormVersionEntity formVersionEntity, Integer inclusionActor, boolean keepAnnotations) {
        formVersionEntity.setFormEntity(entity);
        formVersionEntity.setXml(this.extractContent(instance));
        formVersionEntity.setInclusionActor(inclusionActor);
        this.formVersionDAO.saveOrUpdate(formVersionEntity);
        entity.setCurrentFormVersionEntity(formVersionEntity);
        if (keepAnnotations) {
            this.saveOrUpdateFormAnnotation(instance, formVersionEntity, inclusionActor);
        }
        this.formDAO.saveOrUpdate(entity);
    }

    private void saveOrUpdateFormAnnotation(@Nonnull SInstance instance, @Nonnull FormVersionEntity formVersionEntity, Integer inclusionActor) {
        Map<String, String> classifiedAnnotationsXML = this.extractAnnotations(instance);
        Map<String, FormAnnotationEntity> classifiedAnnotationsEntities = ((List)Optional.ofNullable(formVersionEntity.getFormAnnotations()).orElse(new ArrayList(0))).stream().collect(Collectors.toMap(FormAnnotationEntity::getClassifier, f -> f));
        for (Map.Entry<String, String> entry : classifiedAnnotationsXML.entrySet()) {
            this.saveOrUpdateFormAnnotation(entry.getKey(), entry.getValue(), formVersionEntity, classifiedAnnotationsEntities.get(entry.getKey()), inclusionActor);
        }
        this.formVersionDAO.saveOrUpdate(formVersionEntity);
    }

    private void saveOrUpdateFormAnnotation(String classifier, String xml, FormVersionEntity formVersionEntity, FormAnnotationEntity formAnnotationEntity, Integer inclusionActor) {
        if (formAnnotationEntity == null) {
            this.saveNewFormAnnotation(classifier, xml, formVersionEntity, inclusionActor);
        } else {
            formAnnotationEntity.getAnnotationCurrentVersion().setXml(xml);
        }
    }

    private void saveNewFormAnnotation(String classifier, String xml, FormVersionEntity formVersionEntity, Integer inclusionActor) {
        FormAnnotationEntity formAnnotationEntity = new FormAnnotationEntity();
        formAnnotationEntity.setCod(new FormAnnotationPK());
        formAnnotationEntity.getCod().setClassifier(classifier);
        formAnnotationEntity.getCod().setFormVersionEntity(formVersionEntity);
        this.formAnnotationDAO.save(formAnnotationEntity);
        this.saveOrUpdateFormAnnotationVersion(xml, formAnnotationEntity, new FormAnnotationVersionEntity(), inclusionActor);
        formVersionEntity.getFormAnnotations().add(formAnnotationEntity);
    }

    private void saveOrUpdateFormAnnotationVersion(String xml, FormAnnotationEntity formAnnotationEntity, FormAnnotationVersionEntity formAnnotationVersionEntity, Integer inclusionActor) {
        formAnnotationVersionEntity.setFormAnnotationEntity(formAnnotationEntity);
        formAnnotationVersionEntity.setInclusionDate(formAnnotationVersionEntity.getInclusionDate() == null ? new Date() : formAnnotationVersionEntity.getInclusionDate());
        formAnnotationVersionEntity.setInclusionActor(inclusionActor);
        formAnnotationVersionEntity.setXml(xml);
        this.formAnnotationVersionDAO.saveOrUpdate(formAnnotationVersionEntity);
        formAnnotationEntity.setAnnotationCurrentVersion(formAnnotationVersionEntity);
        this.formAnnotationDAO.save(formAnnotationEntity);
    }

    private void loadCurrentXmlAnnotationOrEmpty(SDocument document, FormVersionEntity formVersionEntity) {
        document.getDocumentAnnotations().clear();
        for (FormAnnotationEntity formAnnotationEntity : Optional.ofNullable(formVersionEntity).map(FormVersionEntity::getFormAnnotations).orElse(Collections.emptyList())) {
            SFormXMLUtil.annotationLoadFromXml((SDocument)document, (String)Optional.ofNullable(formAnnotationEntity.getAnnotationCurrentVersion()).map(FormAnnotationVersionEntity::getXml).orElse(""));
        }
    }

    @Override
    @Nonnull
    public FormEntity loadFormEntity(@Nonnull FormKey key) {
        return (FormEntity)this.formDAO.findOrException(((FormKeyLong)this.formKeyManager.validKeyOrException(key)).longValue());
    }

    @Override
    @Nonnull
    public FormVersionEntity loadFormVersionEntity(@Nonnull Long versionId) {
        return (FormVersionEntity)this.formVersionDAO.findOrException(Objects.requireNonNull(versionId));
    }

    private void updateInternal(@Nonnull FormEntity entity, @Nonnull SInstance instance, Integer inclusionActor) {
        this.saveOrUpdateFormVersion(instance, entity, entity.getCurrentFormVersionEntity(), inclusionActor, true);
        this.formDAO.saveOrUpdate(entity);
    }

    @Nonnull
    private Map<String, String> extractAnnotations(@Nonnull SInstance instance) {
        DocumentAnnotations documentAnnotations = instance.getDocument().getDocumentAnnotations();
        HashMap<String, String> mapClassifierXml = new HashMap<String, String>();
        for (Map.Entry entry : documentAnnotations.persistentAnnotationsClassified().entrySet()) {
            mapClassifierXml.put((String)entry.getKey(), this.extractContent((SInstance)entry.getValue()));
        }
        return mapClassifierXml;
    }

    @Nonnull
    private String extractContent(@Nonnull SInstance instance) {
        return SFormXMLUtil.toStringXMLOrEmptyXML((SInstance)instance);
    }

    @Override
    public FormKey newVersion(@Nonnull SInstance instance, Integer inclusionActor) {
        return this.newVersion(instance, inclusionActor, true);
    }

    @Override
    @Nonnull
    public FormKey newVersion(@Nonnull SInstance instance, Integer inclusionActor, boolean keepAnnotations) {
        FormKey formKey = this.getFormKeyManager().readFormKeyOrException(instance);
        FormEntity formEntity = this.loadFormEntity(formKey);
        FormVersionEntity newFormVersion = new FormVersionEntity();
        this.saveOrUpdateFormVersion(instance, formEntity, newFormVersion, inclusionActor, keepAnnotations);
        return formKey;
    }

    public AnnotationKey insertAnnotation(AnnotationKey annotationKey, SIAnnotation instance) {
        throw new NotImplementedException("N\u00e3o implementado");
    }

    public void deleteAnnotation(AnnotationKey annotationKey) {
        throw new NotImplementedException("N\u00e3o implementado");
    }

    public void updateAnnotation(AnnotationKey annotationKey, SIAnnotation instance) {
        throw new NotImplementedException("N\u00e3o implementado");
    }

    public AnnotationKey insertOrUpdateAnnotation(AnnotationKey annotationKey, SIAnnotation instance) {
        throw new NotImplementedException("N\u00e3o implementado");
    }

    public AnnotationKey newAnnotationVersion(AnnotationKey key, SIAnnotation instance) {
        throw new NotImplementedException("N\u00e3o implementado");
    }

    public AnnotationKey keyFromClassifier(FormKey formKey, String classifier) {
        throw new NotImplementedException("N\u00e3o implementado");
    }

    @Override
    @Nonnull
    public Optional<FormVersionEntity> findCurrentFormVersion(@Nonnull SDocument document) {
        return this.findFormEntity(document).map(FormEntity::getCurrentFormVersionEntity);
    }

    @Override
    @Nonnull
    public Optional<FormEntity> findFormEntity(@Nonnull SDocument document) {
        return FormKey.fromOpt((SDocument)document).map(key -> this.loadFormEntity((FormKey)key));
    }
}

