/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.test;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensingular.lib.commons.base.SingularException;
import org.opensingular.lib.commons.context.SingularContextSetup;
import org.opensingular.server.commons.config.PSingularInitializer;
import org.opensingular.server.commons.config.SingularInitializer;
import org.opensingular.server.commons.test.CommonsInitializerMock;
import org.opensingular.server.commons.test.SingularServletContextMock;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.FileSystemResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpSession;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.support.AbstractContextLoader;
import org.springframework.test.context.web.WebMergedContextConfiguration;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;

public class AbstractSingularContextLoader
extends AbstractContextLoader {
    protected static final Log logger = LogFactory.getLog(AbstractSingularContextLoader.class);

    public final AnnotationConfigWebApplicationContext loadContext(MergedContextConfiguration mergedConfig) throws Exception {
        SingularContextSetup.reset();
        if (!(mergedConfig instanceof WebMergedContextConfiguration)) {
            throw new IllegalArgumentException(String.format("Cannot load WebApplicationContext from non-web merged context configuration %s. Consider annotating your test class with @WebAppConfiguration.", mergedConfig));
        }
        WebMergedContextConfiguration webMergedConfig = (WebMergedContextConfiguration)mergedConfig;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("Loading WebApplicationContext for merged context configuration %s.", webMergedConfig));
        }
        this.validateMergedContextConfiguration(webMergedConfig);
        AnnotationConfigWebApplicationContext context = new AnnotationConfigWebApplicationContext();
        ApplicationContext parent = mergedConfig.getParentApplicationContext();
        if (parent != null) {
            context.setParent(parent);
        }
        this.configureWebResources(context, webMergedConfig);
        this.prepareContext((ConfigurableApplicationContext)context, (MergedContextConfiguration)webMergedConfig);
        this.customizeContext(context, webMergedConfig);
        this.loadBeanDefinitions(context, webMergedConfig);
        this.mockRequest();
        context.refresh();
        context.registerShutdownHook();
        return context;
    }

    private void mockRequest() {
        MockHttpSession session = new MockHttpSession();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setSession((HttpSession)session);
        RequestContextHolder.setRequestAttributes((RequestAttributes)new ServletRequestAttributes((HttpServletRequest)request));
    }

    protected void validateMergedContextConfiguration(WebMergedContextConfiguration mergedConfig) {
    }

    protected void configureWebResources(AnnotationConfigWebApplicationContext context, WebMergedContextConfiguration webMergedConfig) {
        ApplicationContext parent = context.getParent();
        if (parent == null || !(parent instanceof WebApplicationContext)) {
            String resourceBasePath = webMergedConfig.getResourceBasePath();
            DefaultResourceLoader resourceLoader = resourceBasePath.startsWith("classpath:") ? new DefaultResourceLoader() : new FileSystemResourceLoader();
            SingularServletContextMock servletContext = new SingularServletContextMock(resourceBasePath, (ResourceLoader)resourceLoader);
            servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)context);
            context.setServletContext((ServletContext)servletContext);
        } else {
            ServletContext servletContext = null;
            while (parent != null) {
                if (parent instanceof WebApplicationContext && !(parent.getParent() instanceof WebApplicationContext)) {
                    servletContext = ((WebApplicationContext)parent).getServletContext();
                    break;
                }
                parent = parent.getParent();
            }
            Assert.state((servletContext != null ? 1 : 0) != 0, (String)"Failed to find Root WebApplicationContext in the context hierarchy");
            context.setServletContext(servletContext);
        }
    }

    protected void loadBeanDefinitions(AnnotationConfigWebApplicationContext context, WebMergedContextConfiguration webMergedConfig) {
        Object[] annotatedClasses = webMergedConfig.getClasses();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Registering annotated classes: " + ObjectUtils.nullSafeToString((Object[])annotatedClasses)));
        }
        context.register((Class[])annotatedClasses);
    }

    protected void customizeContext(AnnotationConfigWebApplicationContext context, WebMergedContextConfiguration webMergedConfig) {
        try {
            new SingularInitializer((PSingularInitializer)new CommonsInitializerMock(context)).onStartup(context.getServletContext());
        }
        catch (ServletException e) {
            throw SingularException.rethrow((Throwable)e);
        }
    }

    public final ApplicationContext loadContext(String ... locations) throws Exception {
        throw new UnsupportedOperationException("AbstractGenericWebContextLoader does not support the loadContext(String... locations) method");
    }

    protected String getResourceSuffix() {
        return "-context.xml";
    }
}

