/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.test;

import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.opensingular.flow.persistence.entity.ModuleEntity;
import org.opensingular.form.persistence.entity.FormTypeEntity;
import org.opensingular.form.wicket.helpers.AssertionsWComponent;
import org.opensingular.form.wicket.helpers.SingularWicketTester;
import org.opensingular.lib.commons.lambda.IConsumer;
import org.opensingular.lib.commons.util.Loggable;
import org.opensingular.server.commons.form.FormAction;
import org.opensingular.server.commons.persistence.dao.form.RequirementDefinitionDAO;
import org.opensingular.server.commons.persistence.entity.form.RequirementDefinitionEntity;
import org.opensingular.server.commons.test.CommonsConfigurationMock;
import org.opensingular.server.commons.test.SingularCommonsContextLoader;
import org.opensingular.server.commons.wicket.view.form.FormPage;
import org.opensingular.server.commons.wicket.view.util.ActionContext;
import org.springframework.test.annotation.Commit;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

@RunWith(value=SpringJUnit4ClassRunner.class)
@WebAppConfiguration
@ContextConfiguration(classes={CommonsConfigurationMock.class}, loader=SingularCommonsContextLoader.class)
@DirtiesContext(classMode=DirtiesContext.ClassMode.BEFORE_CLASS)
@Transactional
@Commit
public abstract class SingularCommonsBaseTest
implements Loggable {
    @Inject
    protected SessionFactory sessionFactory;
    @Inject
    protected PlatformTransactionManager transactionManager;
    @Inject
    private RequirementDefinitionDAO<RequirementDefinitionEntity> requirementDefinitionDAO;
    protected RequirementDefinitionEntity requirementDefinitionEntity;
    protected Session session;

    @Before
    public void setUp() {
        this.session = this.sessionFactory.getCurrentSession();
        this.createRequirementIfNeeded();
    }

    private void createRequirementIfNeeded() {
        new TransactionTemplate(this.transactionManager).execute(status -> {
            this.requirementDefinitionEntity = (RequirementDefinitionEntity)this.requirementDefinitionDAO.findByUniqueProperty("name", (Object)"Requirement");
            if (this.requirementDefinitionEntity == null) {
                this.requirementDefinitionEntity = new RequirementDefinitionEntity();
                this.requirementDefinitionEntity.setFormType(this.createFormTypeIfNeeded());
                this.requirementDefinitionEntity.setModule(this.getModule());
                this.requirementDefinitionEntity.setName("Requirement");
                this.session.save((Object)this.requirementDefinitionEntity);
            }
            return null;
        });
    }

    @Nonnull
    private FormTypeEntity createFormTypeIfNeeded() {
        FormTypeEntity formTypeEntity = this.session.createCriteria(FormTypeEntity.class).list().stream().findFirst().orElse(null);
        if (formTypeEntity == null) {
            formTypeEntity = new FormTypeEntity();
            formTypeEntity.setAbbreviation("Form");
            formTypeEntity.setLabel("Form");
            formTypeEntity.setCacheVersionNumber(Long.valueOf(1L));
            this.session.saveOrUpdate((Object)formTypeEntity);
        }
        return formTypeEntity;
    }

    public ModuleEntity getModule() {
        return (ModuleEntity)this.session.get(ModuleEntity.class, (Serializable)((Object)"GRUPO_TESTE"));
    }

    public FormPage sendRequirement(SingularWicketTester tester, String formName, IConsumer<Page> formFiller) {
        ActionContext context = new ActionContext();
        context.setFormName(formName);
        context.setFormAction(FormAction.FORM_FILL);
        context.setRequirementDefinitionId(this.requirementDefinitionEntity.getCod());
        FormPage p = new FormPage(context);
        tester.startPage((Page)p);
        tester.assertRenderedPage(FormPage.class);
        formFiller.accept((Object)p);
        tester.executeAjaxEvent((Component)((AssertionsWComponent)new AssertionsWComponent((Component)p).getSubComponentWithId("send-btn")).getTarget(), "click");
        tester.executeAjaxEvent((Component)((AssertionsWComponent)new AssertionsWComponent((Component)p).getSubComponentWithId("confirm-btn")).getTarget(), "click");
        return p;
    }
}

