/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.opensingular.flow.persistence.dao.ModuleDAO;
import org.opensingular.flow.persistence.entity.ModuleEntity;
import org.opensingular.lib.commons.base.SingularException;
import org.opensingular.lib.commons.ui.Icon;
import org.opensingular.lib.support.persistence.entity.BaseEntity;
import org.opensingular.lib.wicket.util.resource.DefaultIcons;
import org.opensingular.server.commons.WorkspaceConfigurationMetadata;
import org.opensingular.server.commons.service.dto.BoxConfigurationData;
import org.opensingular.server.commons.service.dto.BoxDefinitionData;
import org.opensingular.server.commons.service.dto.DatatableField;
import org.opensingular.server.commons.service.dto.ItemBox;
import org.opensingular.server.commons.service.dto.RequirementData;
import org.opensingular.server.commons.service.dto.RequirementDefinitionDTO;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@Named
public class WorkspaceMetadataMockBean {
    private Map<ModuleEntity, WorkspaceConfigurationMetadata> map = new HashMap<ModuleEntity, WorkspaceConfigurationMetadata>();
    @Inject
    private ModuleDAO moduleDAO;
    @Inject
    private PlatformTransactionManager transactionManager;

    @PostConstruct
    public void init() {
        this.configBoxesMock();
    }

    public WorkspaceConfigurationMetadata gimmeSomeMock() {
        WorkspaceConfigurationMetadata w = new WorkspaceConfigurationMetadata();
        w.setBoxesConfiguration(new ArrayList());
        BoxConfigurationData box = new BoxConfigurationData();
        box.setId("id-teste-SingularServerSessionConfigurationMock");
        box.setLabel("super caixa");
        box.setProcesses(new ArrayList());
        RequirementDefinitionDTO p = new RequirementDefinitionDTO("ajaaja", "ajaaja", null, Collections.emptyList());
        box.getProcesses().add(p);
        box.setBoxesDefinition(new ArrayList());
        BoxDefinitionData boxDefinitionData = new BoxDefinitionData();
        ItemBox teste = new ItemBox();
        teste.setName("Rascunho");
        teste.setDescription("Peti\u00e7\u00f5es de rascunho");
        teste.setIcone((Icon)DefaultIcons.DOCS);
        teste.setShowDraft(true);
        teste.setId("1");
        teste.setFieldsDatatable(this.getDatatableFields());
        boxDefinitionData.setRequirements(new ArrayList());
        RequirementData req = new RequirementData();
        req.setLabel("Super req");
        req.setId(Long.valueOf(2L));
        boxDefinitionData.getRequirements().add(req);
        boxDefinitionData.setItemBox(teste);
        box.getBoxesDefinition().add(boxDefinitionData);
        w.getBoxesConfiguration().add(box);
        return w;
    }

    private List<DatatableField> getDatatableFields() {
        ArrayList<DatatableField> fields = new ArrayList<DatatableField>(3);
        fields.add(DatatableField.of((String)"Descri\u00e7\u00e3o", (String)"description"));
        fields.add(DatatableField.of((String)"Dt. Edi\u00e7\u00e3o", (String)"editionDate"));
        fields.add(DatatableField.of((String)"Data de Entrada", (String)"creationDate"));
        return fields;
    }

    private void configBoxesMock() {
        try {
            ModuleEntity moduleEntity = new ModuleEntity();
            new TransactionTemplate(this.transactionManager).execute(transactionStatus -> {
                moduleEntity.setName("Grupo Processo Teste");
                moduleEntity.setCod("GRUPO_TESTE");
                moduleEntity.setConnectionURL("http://localhost:8080/rest/nada");
                this.moduleDAO.saveOrUpdate((BaseEntity)moduleEntity);
                return null;
            });
            this.map.put(moduleEntity, this.gimmeSomeMock());
        }
        catch (Exception e) {
            throw SingularException.rethrow((Throwable)e);
        }
    }

    public Map<ModuleEntity, WorkspaceConfigurationMetadata> getMap() {
        return new LinkedHashMap<ModuleEntity, WorkspaceConfigurationMetadata>(this.map);
    }
}

