/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.test.db;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.Entity;
import org.apache.logging.log4j.util.Strings;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.opensingular.lib.commons.scan.SingularClassPathScanner;
import org.opensingular.lib.commons.util.Loggable;

public class SingularSchemaExport
implements Loggable {
    public static final String SCRIPT_FILE = "exportScript.sql";
    public static final String H2 = "org.hibernate.dialect.H2Dialect";
    public static final String POSTGRE = "org.hibernate.dialect.PostgreSQLDialect";
    public static final String ORACLE = "org.hibernate.dialect.OracleDialect";
    public static final String ORACLE_8I = "org.hibernate.dialect.Oracle8iDialect";
    public static final String ORACLE_9I = "org.hibernate.dialect.Oracle9iDialect";
    public static final String ORACLE_10G = "org.hibernate.dialect.Oracle10gDialect";
    public static final String SQLSERVER = "org.hibernate.dialect.SQLServerDialect";

    public void generateScript() {
        this.generateScript(null, null, null);
    }

    public void generateScript(String packageStr, String dialect, String filename) {
        Set typesAnnotatedWith = SingularClassPathScanner.get().findClassesAnnotatedWith(Entity.class);
        List list = typesAnnotatedWith.stream().filter(c -> Strings.isNotEmpty((CharSequence)packageStr) ? c.getPackage().getName().startsWith(packageStr) : true).collect(Collectors.toList());
        Configuration cfg = new Configuration();
        cfg.setProperty("hibernate.dialect", Strings.isNotEmpty((CharSequence)dialect) ? dialect : H2);
        cfg.setProperty("hibernate.hbm2ddl.auto", "create");
        for (Class c2 : list) {
            cfg.addAnnotatedClass(c2);
        }
        cfg.buildMappings();
        SchemaExport export = new SchemaExport(cfg);
        export.setOutputFile(Strings.isNotEmpty((CharSequence)filename) ? filename : SCRIPT_FILE);
        export.setDelimiter(";");
        export.setFormat(true);
        export.execute(true, false, false, true);
    }
}

