/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.test.spring;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.inject.Named;
import net.vidageek.mirror.dsl.Mirror;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.MockitoJUnitRunner;
import org.opensingular.lib.commons.context.ServiceRegistry;
import org.opensingular.lib.commons.context.ServiceRegistryLocator;
import org.opensingular.lib.commons.context.SingularContextSetup;
import org.opensingular.lib.commons.context.spring.SpringServiceRegistry;
import org.opensingular.lib.commons.scan.SingularClassPathScanner;
import org.opensingular.lib.commons.util.Loggable;
import org.opensingular.lib.support.spring.test.ApplicationContextMock;
import org.opensingular.lib.support.spring.util.ApplicationContextProvider;
import org.opensingular.server.commons.spring.SingularDefaultBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;

public class SingularServerSpringMockitoTestConfig
implements Loggable {
    private TestScan testClasspathScanner = new TestScan();
    private Object myTestClass;

    public SingularServerSpringMockitoTestConfig(Object myTestClass) {
        Class runnerClass;
        if (myTestClass.getClass().isAnnotationPresent(RunWith.class) && (runnerClass = myTestClass.getClass().getDeclaredAnnotation(RunWith.class).value()).isAssignableFrom(MockitoJUnitRunner.class)) {
            this.myTestClass = myTestClass;
            return;
        }
        throw new IllegalArgumentException(this.getClass().getName() + " somente funciona com classes de teste cujo runner seja do tipo: " + MockitoJUnitRunner.class.getName());
    }

    public void resetAndReconfigure(boolean debug) {
        SingularContextSetup.reset();
        ApplicationContextMock applicationContext = new ApplicationContextMock();
        ServiceRegistryLocator.setup((ServiceRegistry)new SpringServiceRegistry());
        new ApplicationContextProvider().setApplicationContext((ApplicationContext)applicationContext);
        this.registerBeanFactories(applicationContext);
        this.registerAnnotated(applicationContext, Named.class);
        this.registerAnnotated(applicationContext, Service.class);
        this.registerAnnotated(applicationContext, Component.class);
        this.registerAnnotated(applicationContext, Repository.class);
        this.registerMockitoTestClassMocksAndSpies(applicationContext);
        this.getLogger().info("Contexto configurado com os beans: ");
        if (debug) {
            applicationContext.listAllBeans().forEach(b -> this.getLogger().info(b));
        }
    }

    public void resetAndReconfigure() {
        this.resetAndReconfigure(false);
    }

    private void registerMockitoTestClassMocksAndSpies(ApplicationContextMock applicationContext) {
        new Mirror().on(this.myTestClass.getClass()).reflectAll().fields().matching(f -> f.isAnnotationPresent(Mock.class) || f.isAnnotationPresent(Spy.class)).forEach(f -> {
            try {
                applicationContext.putOrReplaceBean(f.get(this.myTestClass));
            }
            catch (IllegalAccessException e) {
                this.getLogger().trace(e.getMessage(), (Throwable)e);
            }
        });
    }

    private void registerAnnotated(ApplicationContextMock applicationContext, Class annotation) {
        this.testClasspathScanner.findClassesAnnotatedWith(annotation).forEach(f -> applicationContext.putOrReplaceBean(Mockito.mock((Class)f)));
    }

    private void registerBeanFactories(ApplicationContextMock applicationContext) {
        Sets.SetView beanFactoriesClasses = Sets.union((Set)this.testClasspathScanner.findSubclassesOf(SingularDefaultBeanFactory.class), (Set)this.testClasspathScanner.findClassesAnnotatedWith(Configuration.class));
        beanFactoriesClasses.forEach(c -> this.registerMockBean(applicationContext, (Class<?>)c));
    }

    private void registerMockBean(ApplicationContextMock applicationContext, Class<?> targetClass) {
        new Mirror().on(targetClass).reflectAll().methods().matching(element -> element.isAnnotationPresent(Bean.class)).forEach(m -> {
            if (m.getParameterCount() == 0) {
                try {
                    applicationContext.putOrReplaceBean(m.invoke(Mockito.spy((Class)targetClass), new Object[0]));
                }
                catch (Exception e) {
                    this.getLogger().trace(e.getMessage(), (Throwable)e);
                }
            }
        });
    }

    private static class TestScan
    extends SingularClassPathScanner {
    }
}

