/*
 *
 *  * Copyright (C) 2016 Singular Studios (a.k.a Atom Tecnologia) - www.opensingular.com
 *  *
 *  * Licensed under the Apache License, Version 2.0 (the "License");
 *  *  you may not use this file except in compliance with the License.
 *  * You may obtain a copy of the License at
 *  *
 *  * http://www.apache.org/licenses/LICENSE-2.0
 *  *
 *  * Unless required by applicable law or agreed to in writing, software
 *  * distributed under the License is distributed on an "AS IS" BASIS,
 *  * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  * See the License for the specific language governing permissions and
 *  * limitations under the License.
 *
 */

package org.opensingular.server.commons.persistence.dao;

import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.metadata.ClassMetadata;
import org.opensingular.lib.support.persistence.SimpleDAO;

import javax.inject.Named;
import javax.transaction.Transactional;
import java.util.Map;

@Named
public class HealthSystemDAO extends SimpleDAO {

	@Transactional
	public Map<String, ClassMetadata> getAllDbMetaData(){		
		return sessionFactory.getAllClassMetadata();
	}
	
	@Transactional
	public String getHibernateDialect(){
		return ((SessionFactoryImpl)sessionFactory).getDialect().toString();
	}

}
