/*
 *
 *  * Copyright (C) 2016 Singular Studios (a.k.a Atom Tecnologia) - www.opensingular.com
 *  *
 *  * Licensed under the Apache License, Version 2.0 (the "License");
 *  *  you may not use this file except in compliance with the License.
 *  * You may obtain a copy of the License at
 *  *
 *  * http://www.apache.org/licenses/LICENSE-2.0
 *  *
 *  * Unless required by applicable law or agreed to in writing, software
 *  * distributed under the License is distributed on an "AS IS" BASIS,
 *  * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  * See the License for the specific language governing permissions and
 *  * limitations under the License.
 *
 */

package org.opensingular.server.commons.persistence.dto.healthsystem;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@SuppressWarnings("serial")
public class TableInfoDTO implements Serializable {
	
	private String tableName;
	private String schema;
	private List<String> userPrivs;
	private List<ColumnInfoDTO> columnsInfo;
	private boolean found=false;
	
	public TableInfoDTO() {
		userPrivs = new ArrayList<>();
		columnsInfo = new ArrayList<>();
	}

	public String getTableName() {
		return tableName;
	}

	public void setTableName(String tableName) {
		this.tableName = tableName;
	}

	public String getSchema() {
		return schema;
	}

	public void setSchema(String schema) {
		this.schema = schema;
	}

	public List<String> getUserPrivs() {
		return userPrivs;
	}

	public void setUserPrivs(List<String> userPrivs) {
		this.userPrivs = userPrivs;
	}

	public List<ColumnInfoDTO> getColumnsInfo() {
		return columnsInfo;
	}

	public void setColumnsInfo(List<ColumnInfoDTO> columnsInfo) {
		this.columnsInfo = columnsInfo;
	}

	public boolean isFound() {
		return found;
	}

	public void setFound(boolean found) {
		this.found = found;
	}

}
