/*
 * Copyright (C) 2016 Singular Studios (a.k.a Atom Tecnologia) - www.opensingular.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.opensingular.server.commons.service;

import java.util.Optional;

import javax.inject.Inject;

import org.springframework.transaction.annotation.Transactional;

import org.opensingular.lib.commons.util.Loggable;
import org.opensingular.flow.core.entity.IEntityModule;
import org.opensingular.server.commons.persistence.dao.ParameterDAO;
import org.opensingular.server.commons.persistence.entity.parameter.ParameterEntity;

@Transactional(readOnly = true)
public class ParameterService implements Loggable {

    @Inject
    private ParameterDAO parameterDAO;

    public Optional<ParameterEntity> findByNameAndModule(String name, IEntityModule module) {
        return Optional.ofNullable(parameterDAO.findByNameAndModule(name, module));
    }

    public Optional<ParameterEntity> findByNameAndModule(String name, String module) {
        return Optional.ofNullable(parameterDAO.findByNameAndModule(name, module));
    }

}
