/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.admin.healthsystem;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import org.opensingular.form.AtrRef;
import org.opensingular.form.SFormUtil;
import org.opensingular.form.SType;
import org.opensingular.form.type.basic.AtrBasic;
import org.opensingular.form.type.basic.SPackageBasic;
import org.opensingular.form.type.core.SPackageDocumentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentationMetadataUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)DocumentationMetadataUtil.class.getName());

    public static boolean isHiddenForDocumentation(SType<?> sType) {
        boolean visible = DocumentationMetadataUtil.getAttribute(sType, SPackageBasic.ATR_EXISTS).orElse(Boolean.TRUE);
        visible &= DocumentationMetadataUtil.getAttribute(sType, SPackageBasic.ATR_VISIBLE).orElse(Boolean.TRUE).booleanValue();
        return !(visible &= DocumentationMetadataUtil.getAttribute(sType, SPackageDocumentation.ATR_DOC_HIDDEN).orElse(Boolean.FALSE) == false);
    }

    public static <V> Optional<V> getAttribute(SType<?> type, AtrRef<?, ?, V> ref) {
        if (type.hasAttributeDefinedInHierarchy(ref)) {
            return Optional.ofNullable(type.getAttributeValue(ref));
        }
        return Optional.empty();
    }

    public static TreeSet<String> resolveDependsOn(SType<?> rootType, SType<?> type) {
        TreeSet<String> values = new TreeSet<String>();
        Collection dependOnResolverList = DocumentationMetadataUtil.getAttribute(type, SPackageBasic.ATR_DEPENDS_ON_FUNCTION).map(Supplier::get).orElse(Collections.emptyList());
        for (AtrBasic.DelayedDependsOnResolver func : dependOnResolverList) {
            if (func == null) continue;
            try {
                func.resolve(rootType, type).stream().map(DocumentationMetadataUtil::getLabelForType).collect(() -> values, Set::add, Set::addAll);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                LOGGER.error("Could not resolve dependent types for type: {}", (Object)type.getName());
            }
        }
        return values;
    }

    public static String getLabelForType(SType<?> type) {
        return DocumentationMetadataUtil.getLabelForType(null, type);
    }

    public static String getLabelForType(String defaultString, SType<?> type) {
        if (defaultString == null) {
            String label = type.asAtr().getLabel();
            if (label == null && (label = (String)SFormUtil.getTypeLabel(type.getClass()).orElse(null)) == null) {
                label = type.getNameSimple();
            }
            return label;
        }
        return defaultString;
    }
}

