/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.admin.healthsystem;

import java.util.List;
import javax.annotation.Nonnull;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.string.StringValue;
import org.opensingular.lib.commons.extension.SingularExtensionUtil;
import org.opensingular.lib.commons.ui.Icon;
import org.opensingular.lib.commons.util.Loggable;
import org.opensingular.lib.wicket.util.menu.AbstractMenuItem;
import org.opensingular.lib.wicket.util.menu.MetronicMenu;
import org.opensingular.lib.wicket.util.menu.MetronicMenuGroup;
import org.opensingular.lib.wicket.util.menu.MetronicMenuItem;
import org.opensingular.lib.wicket.util.resource.DefaultIcons;
import org.opensingular.server.commons.admin.healthsystem.extension.AdministrationEntryExtension;
import org.opensingular.server.commons.wicket.view.template.ServerTemplate;

public class HealthSystemPage
extends ServerTemplate
implements Loggable {
    public static final String ENTRY_PATH_PARAM = "entry";
    public static final String HEALTH_SYSTEM_MOUNT_PATH = "/health/${entry}";
    private List<AdministrationEntryExtension> adminEntries;
    private Form<Void> form;

    public HealthSystemPage() {
        this(new PageParameters());
    }

    public HealthSystemPage(PageParameters parameters) {
        super(parameters);
        this.loadExtensions();
        this.addForm();
        this.addContent(parameters.get(ENTRY_PATH_PARAM));
    }

    private void loadExtensions() {
        this.adminEntries = SingularExtensionUtil.get().findExtensionsByClass(AdministrationEntryExtension.class);
    }

    private void addForm() {
        this.form = new Form("form");
        this.add(new Component[]{this.form});
    }

    private void addContent(StringValue entryKey) {
        String id = "content";
        if (entryKey == null || entryKey.isEmpty()) {
            this.form.add(new Component[]{new WebMarkupContainer(id)});
        } else {
            this.adminEntries.stream().filter(i -> entryKey.toString().equals(i.getKey())).findFirst().ifPresent(i -> this.form.add(new Component[]{i.makePanel(id)}));
        }
    }

    protected IModel<String> getContentTitle() {
        return null;
    }

    protected IModel<String> getContentSubtitle() {
        return null;
    }

    protected boolean isWithMenu() {
        return true;
    }

    @Override
    @Nonnull
    protected WebMarkupContainer buildPageMenu(String id) {
        MetronicMenu metronicMenu = new MetronicMenu(id);
        MetronicMenuGroup group = new MetronicMenuGroup((Icon)DefaultIcons.USER, "Administration");
        group.setOpen();
        metronicMenu.addItem((AbstractMenuItem)group);
        this.adminEntries.forEach(entry -> group.addItem((AbstractMenuItem)new MetronicMenuItem(null, entry.name(), HealthSystemPage.class, new PageParameters().add(ENTRY_PATH_PARAM, (Object)entry.getKey()))));
        return metronicMenu;
    }
}

