/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.admin.healthsystem.docs;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.opensingular.form.SType;
import org.opensingular.form.STypeAttachmentList;
import org.opensingular.form.STypeSimple;
import org.opensingular.form.converter.EnumSInstanceConverter;
import org.opensingular.form.provider.ProviderContext;
import org.opensingular.form.type.basic.SPackageBasic;
import org.opensingular.form.type.core.STypeDate;
import org.opensingular.form.type.core.STypeDateTime;
import org.opensingular.form.type.core.STypeTime;
import org.opensingular.form.type.core.attachment.STypeAttachment;
import org.opensingular.form.view.SMultiSelectionByCheckboxView;
import org.opensingular.form.view.SMultiSelectionByPicklistView;
import org.opensingular.form.view.SView;
import org.opensingular.form.view.SViewListByMasterDetail;
import org.opensingular.form.view.ViewResolver;
import org.opensingular.form.wicket.behavior.InputMaskBehavior;
import org.opensingular.lib.commons.util.Loggable;
import org.opensingular.server.commons.admin.healthsystem.DocumentationMetadataUtil;
import org.opensingular.server.commons.admin.healthsystem.docs.DocFieldMetadata;
import org.opensingular.server.commons.admin.healthsystem.docs.HTMLComponentType;

class DocumentationFieldMetadataBuilder
implements Loggable {
    private DocFieldMetadata docFieldMetadata;
    private boolean modal;
    private boolean selection;
    private boolean simple;
    private boolean upload;
    private boolean hiddenForDocumentation;

    public DocumentationFieldMetadataBuilder(SType<?> rootType, SType<?> type) {
        this.modal = this.initModal(type);
        this.selection = this.initSelection(type);
        this.simple = this.initSimpleType(type);
        this.upload = this.initUpload(type);
        this.hiddenForDocumentation = this.initHiddenForDocumentation(type);
        this.docFieldMetadata = this.isFormInputField() ? new DocFieldMetadata(rootType, type, this.initFieldName(type), this.initFieldSubtitle(type), this.initRequired(type), this.initEnabled(type), this.initEnablingRule(type), this.initValidationRule(type), this.initRequiredRule(type), this.initBusinessRules(type), this.initVisibilityRule(type), DocumentationMetadataUtil.resolveDependsOn(rootType, type), this.initMask(type), this.initMaxSize(type), this.initMinSize(type), this.initEnumSelectDomain(type), this.initHtmlComponentType(type), this.initFieldLength(type), this.initMaxUploadInBytes(type)) : null;
    }

    private boolean initBusinessRules(SType<?> type) {
        return DocumentationMetadataUtil.getAttribute(type, SPackageBasic.ATR_UPDATE_LISTENER).isPresent();
    }

    private String initFieldSubtitle(SType<?> type) {
        return StringUtils.defaultString((String)DocumentationMetadataUtil.getAttribute(type, SPackageBasic.ATR_SUBTITLE).orElse(null), null);
    }

    private Long initMaxUploadInBytes(SType<?> type) {
        if (this.upload) {
            SType uploadType = type;
            if (type instanceof STypeAttachmentList) {
                uploadType = ((STypeAttachmentList)type).getElementsType();
            }
            return DocumentationMetadataUtil.getAttribute(uploadType, SPackageBasic.ATR_MAX_FILE_SIZE).orElse(null);
        }
        return null;
    }

    private Integer initFieldLength(SType<?> type) {
        return DocumentationMetadataUtil.getAttribute(type, SPackageBasic.ATR_MAX_LENGTH).orElse(null);
    }

    private HTMLComponentType initHtmlComponentType(SType<?> s) {
        if (this.selection) {
            return this.resolveSelectionType(s);
        }
        if (s instanceof STypeDate) {
            return HTMLComponentType.DATE;
        }
        if (s instanceof STypeDateTime) {
            return HTMLComponentType.DATETIME;
        }
        if (s instanceof STypeTime) {
            return HTMLComponentType.TIME;
        }
        if (s instanceof STypeAttachment) {
            return HTMLComponentType.UPLOAD;
        }
        if (s instanceof STypeAttachmentList) {
            return HTMLComponentType.MULTI_UPLOAD;
        }
        return HTMLComponentType.INPUT_FIELD;
    }

    private HTMLComponentType resolveSelectionType(SType<?> s) {
        if (s.isList()) {
            SView view = ViewResolver.resolveView(s);
            if (view instanceof SMultiSelectionByCheckboxView) {
                return HTMLComponentType.CHECKBOX;
            }
            if (view instanceof SMultiSelectionByPicklistView) {
                return HTMLComponentType.PICK_LIST;
            }
            return HTMLComponentType.MULTI_SELECT;
        }
        return HTMLComponentType.SELECT;
    }

    private List<String> initEnumSelectDomain(SType<?> type) {
        if (this.selection && type.asAtrProvider().getConverter() instanceof EnumSInstanceConverter) {
            return type.asAtrProvider().getProvider().load(new ProviderContext()).stream().map(e -> (String)type.asAtrProvider().getDisplayFunction().apply((Object)((Serializable)e))).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private Integer initMinSize(SType<?> type) {
        return DocumentationMetadataUtil.getAttribute(type, SPackageBasic.ATR_MINIMUM_SIZE).orElse(null);
    }

    private Integer initMaxSize(SType<?> type) {
        return DocumentationMetadataUtil.getAttribute(type, SPackageBasic.ATR_MAXIMUM_SIZE).orElse(null);
    }

    private String initMask(SType<?> type) {
        return StringUtils.defaultString((String)DocumentationMetadataUtil.getAttribute(type, SPackageBasic.ATR_BASIC_MASK).map(InputMaskBehavior.Masks::valueOf).map(InputMaskBehavior.Masks::getMask).orElse(null), null);
    }

    private Boolean initVisibilityRule(SType<?> type) {
        return DocumentationMetadataUtil.getAttribute(type, SPackageBasic.ATR_VISIBLE_FUNCTION).isPresent();
    }

    private Boolean initRequiredRule(SType<?> type) {
        return DocumentationMetadataUtil.getAttribute(type, SPackageBasic.ATR_REQUIRED_FUNCTION).isPresent();
    }

    private Boolean initValidationRule(SType<?> type) {
        return !type.getValidators().isEmpty();
    }

    private Boolean initEnablingRule(SType<?> type) {
        return DocumentationMetadataUtil.getAttribute(type, SPackageBasic.ATR_ENABLED_FUNCTION).isPresent();
    }

    private String initFieldName(SType<?> type) {
        return DocumentationMetadataUtil.getLabelForType(type);
    }

    public boolean isFormInputField() {
        boolean isHtmlFormComponent = this.selection || this.upload || this.simple || this.modal;
        return !this.hiddenForDocumentation && isHtmlFormComponent;
    }

    public DocFieldMetadata getDocFieldMetadata() {
        return this.docFieldMetadata;
    }

    private boolean initModal(SType<?> type) {
        return ViewResolver.resolveView(type) instanceof SViewListByMasterDetail;
    }

    private boolean initHiddenForDocumentation(SType<?> type) {
        return DocumentationMetadataUtil.isHiddenForDocumentation(type);
    }

    private Boolean initRequired(SType<?> s) {
        return DocumentationMetadataUtil.getAttribute(s, SPackageBasic.ATR_REQUIRED).orElse(Boolean.FALSE);
    }

    private Boolean initEnabled(SType<?> s) {
        return DocumentationMetadataUtil.getAttribute(s, SPackageBasic.ATR_ENABLED).orElse(Boolean.TRUE);
    }

    private boolean initSelection(SType<?> type) {
        return type.asAtrProvider().getProvider() != null;
    }

    private boolean initUpload(SType<?> type) {
        return type instanceof STypeAttachment || type instanceof STypeAttachmentList;
    }

    private boolean initSimpleType(SType<?> type) {
        return type instanceof STypeSimple;
    }
}

