/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.admin.healthsystem.docs;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.opensingular.form.SType;
import org.opensingular.form.STypes;
import org.opensingular.form.view.Block;
import org.opensingular.form.view.SView;
import org.opensingular.form.view.SViewByBlock;
import org.opensingular.form.view.SViewListByMasterDetail;
import org.opensingular.form.view.SViewTab;
import org.opensingular.form.view.ViewResolver;
import org.opensingular.lib.commons.lambda.IBiFunction;
import org.opensingular.server.commons.admin.healthsystem.DocumentationMetadataUtil;
import org.opensingular.server.commons.admin.healthsystem.docs.DocBlock;
import org.opensingular.server.commons.admin.healthsystem.docs.DocFieldMetadata;
import org.opensingular.server.commons.admin.healthsystem.docs.DocTable;
import org.opensingular.server.commons.admin.healthsystem.docs.DocumentationFieldMetadataBuilder;

public class DocumentationMetadataBuilder {
    private Map<SType<?>, SView> viewsMap = new HashMap();
    private Map<String, SType<?>> typeByNameCache = new HashMap();
    private LinkedHashSet<DocTable> tableRoots;
    private static SView NULLVIEW = new SView(){};

    private void initTypeByNameCache(SType<?> rootStype) {
        STypes.streamDescendants(rootStype, (boolean)true).forEach(s -> this.typeByNameCache.put(s.getName(), (SType<?>)s));
    }

    public DocumentationMetadataBuilder(SType<?> rootStype) {
        this.initTypeByNameCache(rootStype);
        this.tableRoots = this.identifyTablesRoots(rootStype);
        LinkedHashSet tableRootsSTypes = this.tableRoots.stream().flatMap(d -> d.getRootSTypes().stream()).collect(LinkedHashSet::new, HashSet::add, AbstractCollection::addAll);
        for (DocTable docTable : this.tableRoots) {
            LinkedHashSet<DocBlock> docBlocks = this.identifyBlocks(docTable.getRootSTypes(), tableRootsSTypes);
            docTable.addAllDocBlocks(docBlocks);
            LinkedHashSet<SType<?>> allTypesAssociatedToBlocks = this.gatherAllSTypesAssociatedToBlocks(docBlocks);
            allTypesAssociatedToBlocks.addAll(tableRootsSTypes);
            for (DocBlock docBlock : docBlocks) {
                LinkedHashSet<DocFieldMetadata> docFieldMetadata = this.identifyFields(rootStype, docBlock, CollectionUtils.subtract(allTypesAssociatedToBlocks, docBlock.getBlockTypes()));
                docBlock.addAllFieldsMetadata(docFieldMetadata);
            }
        }
    }

    private LinkedHashSet<DocFieldMetadata> identifyFields(SType<?> rootStype, DocBlock docBlock, Collection<SType<?>> excludedTypes) {
        LinkedHashSet<DocFieldMetadata> fields = new LinkedHashSet<DocFieldMetadata>();
        for (SType sType : docBlock.getBlockTypes()) {
            if (excludedTypes.contains(sType)) continue;
            DocumentationFieldMetadataBuilder docFieldMetadataBuilder = new DocumentationFieldMetadataBuilder(rootStype, sType);
            if (docFieldMetadataBuilder.isFormInputField()) {
                fields.add(docFieldMetadataBuilder.getDocFieldMetadata());
                excludedTypes.add(sType);
                continue;
            }
            fields.addAll(this.identifyFieldsRecursiveIteration(sType, rootStype, excludedTypes));
        }
        return fields;
    }

    private LinkedHashSet<DocFieldMetadata> identifyFieldsRecursiveIteration(SType<?> toIterate, SType<?> rootStype, Collection<SType<?>> excludedTypes) {
        LinkedHashSet<DocFieldMetadata> fields = new LinkedHashSet<DocFieldMetadata>();
        for (SType sType : STypes.containedTypes(toIterate)) {
            if (excludedTypes.contains(sType)) continue;
            DocumentationFieldMetadataBuilder docFieldMetadataBuilder = new DocumentationFieldMetadataBuilder(rootStype, sType);
            if (docFieldMetadataBuilder.isFormInputField()) {
                fields.add(docFieldMetadataBuilder.getDocFieldMetadata());
                excludedTypes.add(sType);
                continue;
            }
            fields.addAll(this.identifyFieldsRecursiveIteration(sType, rootStype, excludedTypes));
        }
        return fields;
    }

    private LinkedHashSet<DocBlock> identifyBlocks(List<SType<?>> rootTypes, LinkedHashSet<SType<?>> tableRootsSTypes) {
        LinkedHashSet<DocBlock> blocks = new LinkedHashSet<DocBlock>();
        for (SType<?> type : rootTypes) {
            blocks.addAll(this.recursiveIteration(type, tableRootsSTypes, this::toStypeToBlockStream));
        }
        this.identifyOrphanTypesBlock(rootTypes, tableRootsSTypes, this.gatherAllSTypesAssociatedToBlocks(blocks)).ifPresent(blocks::add);
        return blocks;
    }

    private LinkedHashSet<SType<?>> gatherAllSTypesAssociatedToBlocks(LinkedHashSet<DocBlock> blocks) {
        return blocks.stream().flatMap(b -> b.getBlockTypes().stream()).collect(LinkedHashSet::new, HashSet::add, AbstractCollection::addAll);
    }

    private <X> LinkedHashSet<X> recursiveIteration(SType<?> toIterate, LinkedHashSet<SType<?>> excludedTypes, IBiFunction<SType<?>, LinkedHashSet<SType<?>>, Stream<X>> function) {
        LinkedHashSet<X> blocks = new LinkedHashSet<X>();
        if (this.isDocumentationRelated(toIterate)) {
            ((Stream)function.apply(toIterate, excludedTypes)).forEach(blocks::add);
            for (SType contained : STypes.containedTypes(toIterate)) {
                if (excludedTypes.contains(contained)) continue;
                ((Stream)function.apply((Object)contained, excludedTypes)).forEach(blocks::add);
                blocks.addAll(this.recursiveIteration(contained, excludedTypes, function));
            }
        }
        return blocks;
    }

    private Optional<DocBlock> identifyOrphanTypesBlock(List<SType<?>> rootTypes, LinkedHashSet<SType<?>> tableRootsSTypes, LinkedHashSet<SType<?>> typesAssociatedToBlocks) {
        ArrayList orphans = new ArrayList();
        LinkedHashSet excludedTypes = new LinkedHashSet();
        excludedTypes.addAll(tableRootsSTypes);
        excludedTypes.addAll(typesAssociatedToBlocks);
        excludedTypes.removeAll(rootTypes);
        for (SType<?> type : rootTypes) {
            if (!this.isDocumentationRelated(type) || excludedTypes.contains(type)) continue;
            orphans.add(type);
            orphans.addAll(this.recursiveIteration(type, excludedTypes, (IBiFunction & Serializable)(s, e) -> e.contains(s) ? Stream.empty() : Stream.of(s)));
        }
        if (orphans.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new DocBlock(null, orphans, true));
    }

    private Stream<DocBlock> toStypeToBlockStream(SType<?> sType, LinkedHashSet<SType<?>> excludedTypes) {
        SView view = this.getViewFor(sType);
        if (view instanceof SViewByBlock) {
            SViewByBlock byBlock = (SViewByBlock)view;
            ArrayList<DocBlock> docBlockList = new ArrayList<DocBlock>();
            for (Block b : byBlock.getBlocks()) {
                List<SType<SType<?>>> list = this.retrieveSTypeListFromRelativeTypeName(sType, b.getTypes());
                list.removeAll(excludedTypes);
                docBlockList.add(new DocBlock(b.getName(), list, false));
            }
            return docBlockList.stream();
        }
        return Stream.empty();
    }

    private List<SType<?>> retrieveSTypeListFromRelativeTypeName(SType<?> sType, List<String> types) {
        return types.stream().map(s -> this.typeByNameCache.get(sType.getName() + "." + s)).collect(Collectors.toList());
    }

    private LinkedHashSet<DocTable> identifyTablesRoots(SType<?> rootType) {
        LinkedHashSet<DocTable> roots = new LinkedHashSet<DocTable>();
        roots.addAll(this.collectTableRoots(rootType));
        roots.addAll(this.identifyTablesRecursion(rootType));
        if (roots.stream().map(DocTable::getRootSTypes).flatMap(Collection::stream).noneMatch(arg_0 -> rootType.equals(arg_0))) {
            roots.add(new DocTable(DocumentationMetadataUtil.getLabelForType(rootType), rootType));
        }
        return roots;
    }

    private LinkedHashSet<DocTable> identifyTablesRecursion(SType<?> toIterate) {
        LinkedHashSet<DocTable> roots = new LinkedHashSet<DocTable>();
        for (SType contained : STypes.containedTypes(toIterate)) {
            roots.addAll(this.collectTableRoots(contained));
            roots.addAll(this.identifyTablesRecursion(contained));
        }
        return roots;
    }

    private LinkedHashSet<DocTable> collectTableRoots(SType<?> sType) {
        LinkedHashSet<DocTable> roots = new LinkedHashSet<DocTable>();
        if (this.isDocumentationRelated(sType)) {
            SView view = this.getViewFor(sType);
            if (view instanceof SViewTab) {
                SViewTab viewTab = (SViewTab)view;
                for (SViewTab.STab t : viewTab.getTabs()) {
                    roots.add(new DocTable(DocumentationMetadataUtil.getLabelForType(t.getTitle(), sType), this.retrieveSTypeListFromRelativeTypeName(sType, t.getTypesNames()).toArray(new SType[0])));
                }
            } else if (view instanceof SViewListByMasterDetail) {
                roots.add(new DocTable(DocumentationMetadataUtil.getLabelForType(sType), sType));
            }
        }
        return roots;
    }

    private boolean isDocumentationRelated(SType<?> sType) {
        return !DocumentationMetadataUtil.isHiddenForDocumentation(sType);
    }

    private SView getViewFor(SType<?> s) {
        SView view = this.viewsMap.get(s);
        if (view == null) {
            view = Optional.ofNullable(ViewResolver.resolveView(s)).orElse(NULLVIEW);
            this.viewsMap.put(s, view);
        }
        if (view == NULLVIEW) {
            view = null;
        }
        return view;
    }

    public LinkedHashSet<DocTable> getMetadata() {
        return this.tableRoots;
    }
}

