/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.admin.healthsystem.docs.presentation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.opensingular.server.commons.admin.healthsystem.docs.DocBlock;
import org.opensingular.server.commons.admin.healthsystem.docs.DocFieldMetadata;
import org.opensingular.server.commons.admin.healthsystem.docs.DocTable;
import org.opensingular.server.commons.admin.healthsystem.docs.presentation.DefaultFormDocumentationColumnRenderer;
import org.opensingular.server.commons.admin.healthsystem.docs.presentation.DefaultFormDocumentationRenderer;
import org.opensingular.server.commons.admin.healthsystem.docs.presentation.DefaultValueConverter;
import org.opensingular.server.commons.admin.healthsystem.docs.presentation.DocumentationDefinition;
import org.opensingular.server.commons.admin.healthsystem.docs.presentation.FormDocumentationColumnRenderer;
import org.opensingular.server.commons.admin.healthsystem.docs.presentation.FormDocumentationRenderer;
import org.opensingular.server.commons.admin.healthsystem.docs.presentation.FormFieldValueConverter;
import org.opensingular.server.commons.admin.healthsystem.docs.presentation.MessagesValueConverter;

public class DefaultDocumentationDefinition
implements DocumentationDefinition {
    @Override
    public FormDocumentationRenderer getRenderer() {
        return new DefaultFormDocumentationRenderer();
    }

    @Override
    public List<FormDocumentationColumnRenderer> getColumns() {
        ArrayList<FormDocumentationColumnRenderer> columns = new ArrayList<FormDocumentationColumnRenderer>();
        columns.add(this.newNumberPerTableColumnRenderer());
        columns.add(new DefaultFormDocumentationColumnRenderer("Nome do Campo", DocFieldMetadata.DocFieldValue.FIELD_NAME));
        columns.add(new DefaultFormDocumentationColumnRenderer("Tipo", DocFieldMetadata.DocFieldValue.HTML_COMPONENT_TYPE));
        columns.add(this.newAlternativeColumnRenderer("Obrigat\u00f3rio", this.getEnablingRuleConverter(DocFieldMetadata.DocFieldValue.HAS_REQUIRED_RULE), DocFieldMetadata.DocFieldValue.HAS_REQUIRED_RULE, DocFieldMetadata.DocFieldValue.REQUIRED));
        columns.add(this.newAlternativeColumnRenderer("Habilitado", this.getEnablingRuleConverter(DocFieldMetadata.DocFieldValue.HAS_ENABLING_RULE), DocFieldMetadata.DocFieldValue.HAS_ENABLING_RULE, DocFieldMetadata.DocFieldValue.ENABLED));
        columns.add(this.newAlternativeColumnRenderer("Tamanho", this.getFieldSizeConverter(), DocFieldMetadata.DocFieldValue.MAX_UPLOAD_SIZE_IN_BYTES, DocFieldMetadata.DocFieldValue.FIELD_LENGTH));
        columns.add(new DefaultFormDocumentationColumnRenderer("Regras", DocFieldMetadata.DocFieldValue.HAS_ENABLING_RULE, DocFieldMetadata.DocFieldValue.HAS_REQUIRED_RULE, DocFieldMetadata.DocFieldValue.HAS_UPDATE_LISTENER, DocFieldMetadata.DocFieldValue.HAS_VISIBILITY_RULE));
        columns.add(new DefaultFormDocumentationColumnRenderer("Mensagens", DocFieldMetadata.DocFieldValue.HAS_VALIDATION_RULE));
        columns.add(new DefaultFormDocumentationColumnRenderer("Dom\u00ednio / M\u00e1scara / Hint / Demais observa\u00e7\u00f5es", DocFieldMetadata.DocFieldValue.ENUM_SELECTION_OPTIONS, DocFieldMetadata.DocFieldValue.MASK, DocFieldMetadata.DocFieldValue.FIELD_SUBTITLE, DocFieldMetadata.DocFieldValue.DEPENDENT_STYPES_FIELDS_NAME, DocFieldMetadata.DocFieldValue.MAX_SIZE, DocFieldMetadata.DocFieldValue.MIN_SIZE));
        return columns;
    }

    private FormFieldValueConverter getEnablingRuleConverter(final DocFieldMetadata.DocFieldValue<?> toOverride) {
        return new DefaultValueConverter(){

            @Override
            public String format(DocFieldMetadata.DocFieldValue<?> fieldValue, Object value) {
                if (fieldValue.equals(toOverride) && ((Boolean)value).booleanValue()) {
                    return "Sim";
                }
                return MessagesValueConverter.getDefault().format(fieldValue, value);
            }
        };
    }

    private FormDocumentationColumnRenderer newNumberPerTableColumnRenderer() {
        return new DefaultFormDocumentationColumnRenderer("N\u00famero", new DocFieldMetadata.DocFieldValue[0]){
            private Map<DocTable, Integer> map;
            {
                this.map = new HashMap<DocTable, Integer>();
            }

            @Override
            public String renderColumn(DocTable table, DocBlock block, DocFieldMetadata fieldMetadata) {
                this.map.putIfAbsent(table, 1);
                int count = this.map.get(table);
                if (fieldMetadata != null) {
                    this.map.put(table, count + 1);
                    return String.valueOf(count);
                }
                return block.getBlockName();
            }
        };
    }

    private FormDocumentationColumnRenderer newAlternativeColumnRenderer(String label, FormFieldValueConverter converter, final DocFieldMetadata.DocFieldValue<?> mainValue, final DocFieldMetadata.DocFieldValue<?> secondaryValue) {
        return new DefaultFormDocumentationColumnRenderer(label, converter, new DocFieldMetadata.DocFieldValue[]{mainValue, secondaryValue}){

            @Override
            public String renderColumn(DocTable table, DocBlock block, DocFieldMetadata fieldMetadata) {
                String result = null;
                if (fieldMetadata.getValue(mainValue) != null) {
                    result = StringUtils.defaultString((String)this.getConverter().format(mainValue, fieldMetadata.getValue(mainValue)), (String)"");
                }
                if (StringUtils.isBlank(result)) {
                    result = StringUtils.defaultString((String)this.getConverter().format(secondaryValue, fieldMetadata.getValue(secondaryValue)), (String)"");
                }
                return result;
            }
        };
    }

    private FormFieldValueConverter getFieldSizeConverter() {
        return new DefaultValueConverter(){

            @Override
            public String format(DocFieldMetadata.DocFieldValue<?> fieldValue, Object value) {
                String result = fieldValue.equals(DocFieldMetadata.DocFieldValue.MAX_UPLOAD_SIZE_IN_BYTES) && value != null ? (Long)value / 0x100000L + "MB" : super.format(fieldValue, value);
                if (StringUtils.isBlank((CharSequence)result)) {
                    result = "N/A";
                }
                return result;
            }
        };
    }
}

