/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.admin.healthsystem.docs.presentation;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.opensingular.server.commons.admin.healthsystem.docs.DocBlock;
import org.opensingular.server.commons.admin.healthsystem.docs.DocFieldMetadata;
import org.opensingular.server.commons.admin.healthsystem.docs.DocTable;
import org.opensingular.server.commons.admin.healthsystem.docs.presentation.FormDocumentationColumnRenderer;
import org.opensingular.server.commons.admin.healthsystem.docs.presentation.FormFieldValueConverter;
import org.opensingular.server.commons.admin.healthsystem.docs.presentation.MessagesValueConverter;

public class DefaultFormDocumentationColumnRenderer
implements FormDocumentationColumnRenderer {
    private String columnName;
    private LinkedHashSet<DocFieldMetadata.DocFieldValue<?>> fieldValues = new LinkedHashSet();
    private String fieldsSeparator = "<BR>";
    private FormFieldValueConverter converter = MessagesValueConverter.getDefault();

    public DefaultFormDocumentationColumnRenderer(String columnName, DocFieldMetadata.DocFieldValue<?> ... fieldValues) {
        this.columnName = columnName;
        this.fieldValues.addAll(Arrays.asList(fieldValues));
    }

    public DefaultFormDocumentationColumnRenderer(String columnName, FormFieldValueConverter converter, DocFieldMetadata.DocFieldValue<?> ... fieldValues) {
        this.columnName = columnName;
        this.converter = converter;
        this.fieldValues.addAll(Arrays.asList(fieldValues));
    }

    public DefaultFormDocumentationColumnRenderer(String columnName, String fieldsSeparator, DocFieldMetadata.DocFieldValue<?> ... fieldValues) {
        this.columnName = columnName;
        this.fieldsSeparator = fieldsSeparator;
        this.fieldValues.addAll(Arrays.asList(fieldValues));
    }

    public DefaultFormDocumentationColumnRenderer(String columnName, String fieldsSeparator, FormFieldValueConverter converter, DocFieldMetadata.DocFieldValue<?> ... fieldValues) {
        this.columnName = columnName;
        this.fieldsSeparator = fieldsSeparator;
        this.converter = converter;
        this.fieldValues.addAll(Arrays.asList(fieldValues));
    }

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    protected LinkedHashSet<DocFieldMetadata.DocFieldValue<?>> getFieldValues() {
        return this.fieldValues;
    }

    protected String getFieldsSeparator() {
        return this.fieldsSeparator;
    }

    protected FormFieldValueConverter getConverter() {
        return this.converter;
    }

    @Override
    public String renderColumn(DocTable table, DocBlock block, DocFieldMetadata fieldMetadata) {
        ArrayList<String> strings = new ArrayList<String>(3);
        for (DocFieldMetadata.DocFieldValue docFieldValue : this.getFieldValues()) {
            strings.add(StringUtils.defaultString((String)this.getConverter().format(docFieldValue, fieldMetadata.getValue(docFieldValue)), (String)""));
        }
        return Joiner.on((String)this.getFieldsSeparator()).join((Iterable)strings.stream().filter(StringUtils::isNotBlank).collect(Collectors.toList()));
    }
}

