/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.admin.healthsystem.docs.presentation;

import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.opensingular.form.SType;
import org.opensingular.lib.commons.table.ColumnType;
import org.opensingular.lib.commons.table.TableOutput;
import org.opensingular.lib.commons.table.TableOutputHtml;
import org.opensingular.lib.commons.table.TablePopulator;
import org.opensingular.lib.commons.table.TableTool;
import org.opensingular.lib.commons.util.Loggable;
import org.opensingular.lib.commons.views.format.ViewOutputHtml;
import org.opensingular.lib.commons.views.format.ViewOutputHtmlWriterWrap;
import org.opensingular.server.commons.admin.healthsystem.docs.DocBlock;
import org.opensingular.server.commons.admin.healthsystem.docs.DocFieldMetadata;
import org.opensingular.server.commons.admin.healthsystem.docs.DocTable;
import org.opensingular.server.commons.admin.healthsystem.docs.DocumentationMetadataBuilder;
import org.opensingular.server.commons.admin.healthsystem.docs.presentation.FormDocumentationColumnRenderer;
import org.opensingular.server.commons.admin.healthsystem.docs.presentation.FormDocumentationRenderer;

public class DefaultFormDocumentationRenderer
implements FormDocumentationRenderer,
Loggable {
    private static final String CHARSET = "UTF-8";

    @Override
    public void renderTables(SType<?> rootStype, List<FormDocumentationColumnRenderer> columns, Writer writer) {
        LinkedHashSet<DocTable> metadata = this.getMetadata(rootStype);
        TableOutput html = this.getTableOutputHtml(writer);
        for (DocTable table : metadata) {
            TableTool tableTool = this.newTableTool(table, columns);
            TablePopulator populator = tableTool.createSimpleTablePopulator();
            for (List<String> row : this.convertToRows(table, columns)) {
                populator.insertLine((Object[])row.toArray(new String[row.size()]));
            }
            tableTool.generate(html);
        }
    }

    private List<List<String>> convertToRows(DocTable table, List<FormDocumentationColumnRenderer> columns) {
        ArrayList<List<String>> rowsList = new ArrayList<List<String>>();
        for (DocBlock block : table.getBlockList()) {
            for (DocFieldMetadata fieldMetadata : block.getMetadataList()) {
                ArrayList<String> row = new ArrayList<String>(columns.size());
                for (FormDocumentationColumnRenderer col : columns) {
                    row.add(col.renderColumn(table, block, fieldMetadata));
                }
                rowsList.add(row);
            }
        }
        return rowsList;
    }

    private TableTool newTableTool(DocTable table, List<FormDocumentationColumnRenderer> columns) {
        TableTool tableTool = new TableTool();
        for (FormDocumentationColumnRenderer renderer : columns) {
            tableTool.addColumn(ColumnType.HTML, renderer.getColumnName());
        }
        tableTool.addSuperTitle(0, columns.size() - 1, table.getName());
        return tableTool;
    }

    protected LinkedHashSet<DocTable> getMetadata(SType<?> stype) {
        return new DocumentationMetadataBuilder(stype).getMetadata();
    }

    protected TableOutput getTableOutputHtml(Writer writer) {
        try {
            return new TableOutputHtml((ViewOutputHtml)new ViewOutputHtmlWriterWrap(writer, true));
        }
        catch (Exception e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

