/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.admin.healthsystem.docs.presentation;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.opensingular.server.commons.admin.healthsystem.docs.DocFieldMetadata;
import org.opensingular.server.commons.admin.healthsystem.docs.presentation.DefaultValueConverter;

public class MessagesValueConverter
extends DefaultValueConverter {
    public static final String DOCUMENTATION_MESSAGES_UTF8_PROPERTIES = "documentation-messages.utf8.properties";
    public static final String DEFAULT_DOCUMENTATION_MESSAGES_UTF8_PROPERTIES = "default-documentation-messages.utf8.properties";
    private static final MessagesValueConverter DEFAULT = new MessagesValueConverter();
    private Properties messages;

    public MessagesValueConverter(Properties messages) {
        this.messages = messages;
    }

    public static MessagesValueConverter getDefault() {
        return DEFAULT;
    }

    private MessagesValueConverter() {
        try {
            this.messages = new Properties();
            this.loadDefaultMessages(this.messages);
            this.loadUserMessages(this.messages);
        }
        catch (Exception e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
        }
    }

    private void loadDefaultMessages(Properties messages) throws IOException {
        messages.load(this.findProperties(DEFAULT_DOCUMENTATION_MESSAGES_UTF8_PROPERTIES));
    }

    private void loadUserMessages(Properties messages) throws IOException {
        messages.load(this.findProperties(DOCUMENTATION_MESSAGES_UTF8_PROPERTIES));
    }

    private Reader findProperties(String name) throws IOException {
        URL u = Thread.currentThread().getContextClassLoader().getResource(name);
        if (u != null) {
            this.getLogger().info("Using documentation properties: {}", (Object)name);
            return new InputStreamReader(u.openStream(), Charset.forName("UTF-8"));
        }
        return new CharArrayReader(new char[0]);
    }

    @Override
    public String format(DocFieldMetadata.DocFieldValue<?> fieldValue, Object value) {
        String defaultValue = this.defaultToString(value);
        String message = this.findMessage(fieldValue, defaultValue);
        return this.filterMessage(defaultValue, message);
    }

    protected String findMessage(DocFieldMetadata.DocFieldValue<?> fieldValue, String defaultValue) {
        String propertyName = fieldValue.getKey() + "." + defaultValue;
        String message = this.messages.getProperty(propertyName);
        if (message == null) {
            message = this.messages.getProperty(fieldValue.getKey());
        }
        return message;
    }

    protected String filterMessage(String defaultValue, @Nullable String message) {
        if (message == null) {
            return defaultValue;
        }
        if (defaultValue == null) {
            return message;
        }
        return message.replaceAll(Pattern.quote("{}"), defaultValue);
    }
}

