/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.admin.healthsystem.panel;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.component.IRequestablePage;
import org.opensingular.form.SFormUtil;
import org.opensingular.form.SInfoType;
import org.opensingular.form.STypeComposite;
import org.opensingular.form.spring.SpringTypeLoader;
import org.opensingular.lib.commons.scan.SingularClassPathScanner;
import org.opensingular.lib.commons.ui.Icon;
import org.opensingular.lib.commons.util.Loggable;
import org.opensingular.lib.wicket.util.datatable.BSDataTable;
import org.opensingular.lib.wicket.util.datatable.BSDataTableBuilder;
import org.opensingular.lib.wicket.util.datatable.BaseDataProvider;
import org.opensingular.lib.wicket.util.datatable.IBSAction;
import org.opensingular.lib.wicket.util.datatable.column.BSActionColumn;
import org.opensingular.lib.wicket.util.resource.DefaultIcons;
import org.opensingular.lib.wicket.util.util.WicketUtils;
import org.opensingular.server.commons.admin.healthsystem.docs.DocumentationTablePage;
import org.opensingular.server.commons.spring.security.PermissionResolverService;

public class DocsPanel
extends Panel
implements Loggable {
    @Inject
    protected SpringTypeLoader typeLoader;
    protected BSDataTable<Class<? extends STypeComposite>, String> listTable;
    @Inject
    private PermissionResolverService permissionResolverService;

    public DocsPanel(String id) {
        super(id);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.listTable = this.setupDataTable();
        this.queue(new Component[]{this.listTable});
    }

    protected BSDataTable<Class<? extends STypeComposite>, String> setupDataTable() {
        return new BSDataTableBuilder(this.createDataProvider()).appendPropertyColumn((IModel)WicketUtils.$m.ofValue((Serializable)((Object)"Formul\u00e1rios Encontrados")), this::formatLabel).appendActionColumn("Docs Table", this::buildColumn).setRowsPerPage(Long.MAX_VALUE).setStripedRows(false).setBorderedTable(false).build("tabela");
    }

    private void buildColumn(BSActionColumn<Class<? extends STypeComposite>, String> actionColumn) {
        actionColumn.appendAction((IModel)WicketUtils.$m.ofValue((Serializable)((Object)"Gerar Tabela")), (Icon)DefaultIcons.MAGIC, (IBSAction & Serializable)(a, s) -> this.createTable(a, (IModel<Class<? extends STypeComposite>>)s, false));
        actionColumn.appendAction((IModel)WicketUtils.$m.ofValue((Serializable)((Object)"Gerar Excel")), (Icon)DefaultIcons.ROCKET, (IBSAction & Serializable)(a, s) -> this.createTable(a, (IModel<Class<? extends STypeComposite>>)s, true));
    }

    private void createTable(AjaxRequestTarget ajaxRequestTarget, IModel<Class<? extends STypeComposite>> model, boolean excel) {
        this.setResponsePage((IRequestablePage)new DocumentationTablePage((Class)model.getObject(), excel));
    }

    private String formatLabel(Class<? extends STypeComposite> c) {
        String typeName = SFormUtil.getTypeName(c);
        return SFormUtil.getTypeLabel(c).map(l -> l + " (" + typeName + ")").orElse(typeName);
    }

    private BaseDataProvider<Class<? extends STypeComposite>, String> createDataProvider() {
        return new BaseDataProvider<Class<? extends STypeComposite>, String>(){

            public long size() {
                return Long.MAX_VALUE;
            }

            public Iterator<? extends Class<? extends STypeComposite>> iterator(int first, int count, String sortProperty, boolean ascending) {
                return DocsPanel.this.listCompositeTypes().iterator();
            }
        };
    }

    public List<Class<? extends STypeComposite>> listCompositeTypes() {
        return SingularClassPathScanner.get().findSubclassesOf(STypeComposite.class).stream().filter(c -> !c.getPackage().getName().startsWith("org.opensingular") && !c.getPackage().getName().startsWith("com.opensingular")).filter(c -> c.isAnnotationPresent(SInfoType.class)).sorted((c1, c2) -> new CompareToBuilder().append((Object)this.formatLabel((Class<? extends STypeComposite>)c1), (Object)this.formatLabel((Class<? extends STypeComposite>)c2)).build()).collect(Collectors.toList());
    }
}

