/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.admin.healthsystem.panel;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nonnull;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.ResourceLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.ResourceStreamResource;
import org.apache.wicket.util.resource.FileResourceStream;
import org.apache.wicket.util.resource.IResourceStream;
import org.opensingular.lib.commons.util.Loggable;

public class LogPanel
extends Panel
implements Loggable {
    public LogPanel(String id) {
        super(id);
        this.addLogListView();
    }

    private void addLogListView() {
        this.add(new Component[]{new ListView<URI>("logs", this.resolveLogsURIs()){

            protected void populateItem(ListItem<URI> item) {
                ResourceStreamResource lopZipStream = LogPanel.this.makeZipLogStream((IModel<URI>)item.getModel());
                lopZipStream.setFileName("log.zip");
                ResourceLink downloadLink = new ResourceLink("log", (IResource)lopZipStream);
                downloadLink.add(new Component[]{new Label("label", (Serializable)((Object)Paths.get((URI)item.getModelObject()).getFileName().toString()))});
                item.add(new Component[]{downloadLink});
            }
        }});
    }

    @Nonnull
    private ResourceStreamResource makeZipLogStream(final IModel<URI> logPath) {
        return new ResourceStreamResource(){

            protected IResourceStream getResourceStream() {
                try {
                    return new FileResourceStream(new org.apache.wicket.util.file.File(LogPanel.this.makeZip((IModel<URI>)logPath)));
                }
                catch (IOException ex) {
                    LogPanel.this.getLogger().error(ex.getMessage(), (Throwable)ex);
                    return null;
                }
            }
        };
    }

    @Nonnull
    private File makeZip(IModel<URI> logUriModel) throws IOException {
        byte[] buffer = new byte[1024];
        Path logPath = Paths.get((URI)logUriModel.getObject());
        File zip = org.apache.wicket.util.file.File.createTempFile((String)"log", (String)".zip");
        try (FileOutputStream fos = new FileOutputStream(zip);){
            this.makeZip(buffer, logPath, fos);
        }
        return zip;
    }

    private void makeZip(byte[] buffer, Path logPath, FileOutputStream fos) throws IOException {
        ZipEntry ze = new ZipEntry(logPath.getFileName().toString());
        try (ZipOutputStream zos = new ZipOutputStream(fos);){
            zos.putNextEntry(ze);
            try (FileInputStream in = new FileInputStream(logPath.toFile());){
                int len;
                while ((len = in.read(buffer)) > 0) {
                    zos.write(buffer, 0, len);
                }
                zos.closeEntry();
            }
        }
    }

    @Nonnull
    private ArrayList<URI> resolveLogsURIs() {
        ArrayList<URI> uris = new ArrayList<URI>();
        try {
            Path logDir = this.resolveLogDirPath();
            DirectoryStream<Path> children = Files.newDirectoryStream(logDir);
            children.forEach(path -> uris.add(path.toUri()));
            children.close();
        }
        catch (IOException ex) {
            this.getLogger().error(ex.getMessage(), (Throwable)ex);
        }
        return uris;
    }

    private Path resolveLogDirPath() {
        Path jbossHomeDir = Paths.get(System.getProperty("jboss.home.dir"), new String[0]);
        Path singularHomeDir = jbossHomeDir.getParent();
        return singularHomeDir.resolve("logs");
    }
}

