/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.admin.healthsystem.panel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.opensingular.lib.commons.util.Loggable;
import org.opensingular.lib.wicket.util.datatable.BSDataTable;
import org.opensingular.lib.wicket.util.datatable.BSDataTableBuilder;
import org.opensingular.lib.wicket.util.datatable.BaseDataProvider;
import org.opensingular.lib.wicket.util.util.WicketUtils;
import org.opensingular.server.commons.service.RequirementService;
import org.opensingular.server.commons.spring.security.PermissionResolverService;
import org.opensingular.server.commons.spring.security.SingularPermission;

public class PermissionPanel
extends Panel
implements Loggable {
    @Inject
    protected RequirementService<?, ?> requirementService;
    protected BSDataTable<SingularPermission, String> listTable;
    @Inject
    private PermissionResolverService permissionResolverService;

    public PermissionPanel(String id) {
        super(id);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.listTable = this.setupDataTable();
        this.queue(new Component[]{this.listTable});
    }

    protected BSDataTable<SingularPermission, String> setupDataTable() {
        return new BSDataTableBuilder(this.createDataProvider()).appendPropertyColumn((IModel)WicketUtils.$m.ofValue((Serializable)((Object)"Permiss\u00e3o Singular")), SingularPermission::getSingularId).setRowsPerPage(Long.MAX_VALUE).setStripedRows(false).setBorderedTable(false).build("tabela");
    }

    private BaseDataProvider<SingularPermission, String> createDataProvider() {
        return new BaseDataProvider<SingularPermission, String>(){

            public long size() {
                return Long.MAX_VALUE;
            }

            public Iterator<SingularPermission> iterator(int first, int count, String sortProperty, boolean ascending) {
                List<SingularPermission> singularPermissions = PermissionPanel.this.listAllPermissions();
                if (singularPermissions != null) {
                    return singularPermissions.iterator();
                }
                return Collections.EMPTY_LIST.iterator();
            }
        };
    }

    public List<SingularPermission> listAllPermissions() {
        ArrayList<SingularPermission> permissions = new ArrayList<SingularPermission>();
        permissions.addAll(this.permissionResolverService.listAllCategoryPermissions());
        permissions.addAll(this.permissionResolverService.listAllTypePermissions());
        permissions.addAll(this.permissionResolverService.listAllProcessesPermissions());
        for (SingularPermission permission : permissions) {
            permission.setInternalId(null);
        }
        return permissions;
    }
}

