/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.admin.healthsystem.panel;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.opensingular.form.SFormUtil;
import org.opensingular.form.SPackage;
import org.opensingular.form.SType;
import org.opensingular.form.context.SFormConfig;
import org.opensingular.form.io.FormToXSDConfig;
import org.opensingular.form.io.FormXSDUtil;
import org.opensingular.internal.lib.commons.xml.MElement;
import org.opensingular.lib.commons.lambda.IFunction;
import org.opensingular.lib.commons.scan.SingularClassPathScanner;
import org.opensingular.lib.commons.ui.Icon;
import org.opensingular.lib.wicket.util.datatable.BSDataTableBuilder;
import org.opensingular.lib.wicket.util.datatable.BaseDataProvider;
import org.opensingular.lib.wicket.util.datatable.IBSAction;
import org.opensingular.lib.wicket.util.modal.BSModalBorder;
import org.opensingular.lib.wicket.util.resource.DefaultIcons;

public class XSDViewPanel
extends Panel {
    private List<String> allTypes;
    private Model<String> xsdModel = new Model();
    private BSModalBorder modal;
    @Inject
    private SFormConfig<String> sFormConfig;

    public XSDViewPanel(String id) {
        super(id);
        this.loadAllTypes();
        this.addModal();
        this.addTable();
    }

    private void addTable() {
        BSDataTableBuilder builder = new BSDataTableBuilder((ISortableDataProvider)new BaseDataProvider<String, String>(){

            public Iterator<? extends String> iterator(int first, int count, String sortProperty, boolean ascending) {
                return XSDViewPanel.this.allTypes.subList(first, first + count).iterator();
            }

            public long size() {
                return XSDViewPanel.this.allTypes.size();
            }
        });
        builder.appendPropertyColumn("Nome", (IFunction & Serializable)i -> i);
        builder.appendActionColumn("", (BSDataTableBuilder.BSActionColumnCallback & Serializable)column -> column.appendAction((IModel)new Model(), (Icon)DefaultIcons.EYE, (IBSAction & Serializable)(target, model) -> this.sFormConfig.getTypeLoader().loadType((Serializable)model.getObject()).ifPresent(type -> {
            MElement element = FormXSDUtil.toXsd((SType)type, (FormToXSDConfig)FormToXSDConfig.newForUserDisplay());
            StringWriter writer = new StringWriter();
            element.printTabulado(new PrintWriter(writer));
            this.xsdModel.setObject((Serializable)((Object)writer.toString()));
            this.modal.show(target);
        })));
        this.add(new Component[]{builder.build("table")});
    }

    private void addModal() {
        this.modal = new BSModalBorder("modal");
        this.modal.add(new Component[]{new Label("xsd", this.xsdModel)});
        this.add(new Component[]{this.modal});
    }

    private void loadAllTypes() {
        this.allTypes = SingularClassPathScanner.get().findSubclassesOf(SType.class).stream().filter(f -> !Modifier.isAbstract(f.getModifiers()) && !f.isAssignableFrom(SPackage.class)).map(i -> SFormUtil.getTypeName((Class)i)).collect(Collectors.toList());
    }
}

