/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.server.commons.admin.healthsystem.stypes;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.opensingular.form.SIComposite;
import org.opensingular.form.SIList;
import org.opensingular.form.SInfoType;
import org.opensingular.form.SType;
import org.opensingular.form.STypeComposite;
import org.opensingular.form.STypeList;
import org.opensingular.form.TypeBuilder;
import org.opensingular.form.type.core.SIBoolean;
import org.opensingular.form.type.core.SIString;
import org.opensingular.form.type.core.STypeBoolean;
import org.opensingular.form.type.core.STypeString;
import org.opensingular.form.validation.InstanceValidatable;
import org.opensingular.form.view.SViewListByMasterDetail;
import org.opensingular.form.view.SViewListByTable;
import org.opensingular.lib.support.persistence.util.SqlUtil;
import org.opensingular.server.commons.admin.healthsystem.stypes.SSystemHealthPackage;

@SInfoType(spackage=SSystemHealthPackage.class, newable=true, name="dbhealth")
public class SDbHealth
extends STypeComposite<SIComposite> {
    public STypeList<STypeComposite<SIComposite>, SIComposite> tablesList;
    public STypeBoolean found;
    public STypeString schema;
    public STypeList<STypeString, SIString> userPrivs;
    public STypeBoolean foundDataBase;
    public STypeBoolean foundHibernate;
    public STypeBoolean nullable;
    public STypeList<STypeComposite<SIComposite>, SIComposite> columnsInfo;

    protected void onLoadType(@Nonnull TypeBuilder tb) {
        this.tablesList = this.addFieldListOfComposite("tablesList", "tabela");
        this.tablesList.setView(() -> (SViewListByMasterDetail)((SViewListByMasterDetail)new SViewListByMasterDetail().fullSize().disableNew()).disableDelete());
        STypeComposite table = (STypeComposite)this.tablesList.getElementsType();
        this.schema = table.addFieldString("schema");
        this.schema.asAtr().label("Schema").maxLength(Integer.valueOf(20)).enabled(true).asAtrBootstrap().colPreference(Integer.valueOf(2));
        table.addFieldString("tableName").asAtr().label("Nome").maxLength(Integer.valueOf(50)).enabled(true).asAtrBootstrap().colPreference(Integer.valueOf(2));
        this.found = table.addFieldBoolean("found");
        this.found.asAtr().label("Encontrado no Banco").enabled(true).asAtrBootstrap().colPreference(Integer.valueOf(2));
        this.userPrivs = table.addFieldListOf("userPrivs", STypeString.class);
        this.userPrivs.asAtr().label("Permiss\u00f5es").enabled(true).asAtrBootstrap().colPreference(Integer.valueOf(2));
        this.userPrivs.setView(() -> (SViewListByTable)((SViewListByTable)new SViewListByTable().disableNew()).disableDelete());
        table.addInstanceValidator(this::tableValidation);
        this.columnsInfo = table.addFieldListOfComposite("columnsInfo", "column");
        this.columnsInfo.setView(() -> (SViewListByTable)((SViewListByTable)new SViewListByTable().disableNew()).disableDelete());
        this.columnsInfo.asAtr().label("Colunas");
        STypeComposite column = (STypeComposite)this.columnsInfo.getElementsType();
        column.addFieldString("columnName").asAtr().label("Nome").maxLength(Integer.valueOf(50)).enabled(true).asAtrBootstrap().colPreference(Integer.valueOf(2));
        STypeString dataType = column.addFieldString("dataType");
        dataType.selectionOf((Serializable[])new String[]{"CHAR", "CLOB", "DATE", "DATETIME", "NUMBER", "VARCHAR", "VARCHAR2"}).asAtr().label("Tipo de Dados").maxLength(Integer.valueOf(10)).enabled(true).asAtrBootstrap().colPreference(Integer.valueOf(2));
        column.addFieldInteger("dataLength").asAtr().label("Tamanho(Bytes)").enabled(true).asAtrBootstrap().colPreference(Integer.valueOf(1));
        column.addFieldInteger("charLength").asAtr().label("Tamanho(Caracteres)").enabled(true).asAtrBootstrap().colPreference(Integer.valueOf(1));
        column.addFieldInteger("dataPrecision").asAtr().label("Precisao(valores numericos)").asAtrBootstrap().colPreference(Integer.valueOf(1));
        this.nullable = column.addFieldBoolean("nullable");
        this.nullable.asAtr().label("Aceita null").asAtrBootstrap().colPreference(Integer.valueOf(1));
        this.foundHibernate = column.addFieldBoolean("foundHibernate");
        this.foundHibernate.asAtr().label("Encontrado no Hibernate").enabled(true).asAtrBootstrap().colPreference(Integer.valueOf(2));
        this.foundDataBase = column.addFieldBoolean("foundDataBase");
        this.foundDataBase.asAtr().label("Encontrado no Banco").enabled(true).asAtrBootstrap().colPreference(Integer.valueOf(2));
        column.addInstanceValidator(this::columnValidation);
    }

    private void columnValidation(InstanceValidatable<SIComposite> validatable) {
        Optional databaseFieldInstance = ((SIComposite)validatable.getInstance()).findNearest((SType)this.foundDataBase);
        Optional hibernateFieldInstance = ((SIComposite)validatable.getInstance()).findNearest((SType)this.foundHibernate);
        if (hibernateFieldInstance.isPresent() && ((Boolean)((SIBoolean)hibernateFieldInstance.get()).getValue()).booleanValue() && databaseFieldInstance.isPresent() && !((Boolean)((SIBoolean)databaseFieldInstance.get()).getValue()).booleanValue()) {
            validatable.error("Inconsistency between database and Hibernate!");
        } else {
            Optional nullableFieldInstance = ((SIComposite)validatable.getInstance()).findNearest((SType)this.nullable);
            Optional listObj = ((SIComposite)validatable.getInstance()).findNearest(this.userPrivs);
            List<Object> listPrivs = listObj.map(SIList::getValue).orElse(Collections.emptyList());
            ArrayList vals = new ArrayList();
            listPrivs.forEach(obj -> vals.add((String)obj));
            if (!(!nullableFieldInstance.isPresent() || ((Boolean)((SIBoolean)nullableFieldInstance.get()).getValue()).booleanValue() || vals.contains("INSERT") && vals.contains("UPDATE"))) {
                validatable.error("Column NOT NULL without SELECT or UPDATE permissions");
            }
        }
    }

    private void tableValidation(InstanceValidatable<SIComposite> validatable) {
        SIString foundSchemaFieldInstance;
        Optional foundTableInstance = ((SIComposite)validatable.getInstance()).findNearest((SType)this.found);
        if (!foundTableInstance.isPresent() || !((Boolean)((SIBoolean)foundTableInstance.get()).getValue()).booleanValue()) {
            validatable.error("Table not found!");
        }
        Optional foundSchemaField = ((SIComposite)validatable.getInstance()).findNearest((SType)this.schema);
        Optional listObj = ((SIComposite)validatable.getInstance()).findNearest(this.userPrivs);
        List<Object> listPrivs = listObj.map(SIList::getValue).orElse(Collections.emptyList());
        ArrayList vals = new ArrayList();
        listPrivs.forEach(obj -> vals.add((String)obj));
        if (foundSchemaField.isPresent() && SqlUtil.isSingularSchema((String)((String)((Object)(foundSchemaFieldInstance = (SIString)foundSchemaField.get()).getValue()))) && SqlUtil.hasCompleteCrud(vals)) {
            validatable.error("Singular table without complete CRUD!");
        }
    }
}

